﻿<?php
	/************************************************************************
		Copyright Daniel Brinca 2011 - All Rights Reserved
		Permitted use only with explicit license by http://hdustream.com
	*************************************************************************/
	/*
		Accepted querystring parameters (all are optional):
			station: the id of a station to use, taken from the stations list
			
		Example: index.php?station=danielbrincacom
	*/
	
	//array of stations that will appear on the generator form, in the format id* => label 
	//*id is the station id on config.php, and can be a comma-separated list of station ids (the first one is the one to be played by default)
	$stations = array();
	$stations["radio1"] = "Misión FM";
	$stations["radio2"] = "Radio Candela";
	$stations["radio3"] = "Extrema On Line";
	$stations["radio4"] = "Cuyabeno FM";
	$stations["radio5"] = "Yvypyta Digital";
	$stations["radio6"] = "La Reina";
	$stations["radio7"] = "Buenisima FM";
	$stations["radio8"] = "Sofia";
	$stations["radio9"] = "Demo";
	$stations["radio10"] = "Demo";
	
	
	//+++++++++++++++++++++++++++++++++++++++++++
	// CODE - Don't edit unless you know what you're doing
	//+++++++++++++++++++++++++++++++++++++++++++
	
	//station
	$station = $_GET["station"];
	if (!$station)
		$station = $stations["default"];
	
	//base path
	$basePath = 'http://'.$_SERVER["HTTP_HOST"].preg_replace("/\/$/", "", dirname($_SERVER["SCRIPT_NAME"]));
	
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<title>Intercomsi. | Player AAC+ sin RTMP</title>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<meta name="language" content="en" />
	<meta name="description" content="HDUSTREAM.COM LLC. | Player AAC+ sin Wowza, FMS, Red5" />
	<meta name="keywords" content="radio streaming aac, aac player, radio streaming, cheap hosting, hosting, web hosting" />
	
	<style type="text/css">
		html, body { height:100%; background-color: #999; }
		body { margin: 10px; font-size: 11px; font-family: Arial; color: #222; }
		
		#codeContainer { margin: 10px 0px; padding: 5px; color: #333; border: 1px solid #888; background: #BBB; }
		
		h2 { margin-top: 40px; color: #000;}
		h3 { margin-top: 20px; color: #000;}
		
		form { padding: 0px 10px; }
		
		a { color: #005E8A; }
		
		p {margin: 2px 20px; }
	</style>
	
	<script type="text/javascript">
		function refresh(skipPlayerRefresh){
			var form = document.getElementById("embedForm");
			
			var code = "<div class=\"player\">\r\n";
			code += "\t<script type=\"text/javascript\"><!-"+"-\r\n";
			code += "\t\tvar config = {\r\n";
			
			if (form.volume.value != "100")
				code += "\t\t\t\"volumeLevel\" : \"" + form.volume.value + "\",\r\n";
			
			if (form.colors.value)
				code += "\t\t\t\"colors\" : \"" + form.colors.value + "\",\r\n";
			
			if (form.mode.value == "mini" && !form.miniCover.checked)
				code += "\t\t\t\"width\" : \"250\",\r\n";
			
			if (form.language.value)
				code += "\t\t\t\"defaultLanguage\" : \"" + form.language.value + "\",\r\n";
				
			code += "\t\t\t\"defaultStation\" : \"" + form.station.value + "\",\r\n";
			code += "\t\t\t\"autoplay\" : \"" + (form.autoplay.checked? "true" : "false") + "\",\r\n";
			code += "\t\t\t\"mode\" : \"" + form.mode.value + "\"\r\n";
			
			code += "\t\t}\r\n";
			code += "\t//-"+"->\r\n";
			code += "\t</"+"script>\r\n";
			code += "\t<script type=\"text/javascript\" src=\"<?=$basePath ?>/player.js\"></"+"script>\r\n";
			code += "</div>";
			
			var codeContainer = document.getElementById("codeContainer");
			codeContainer.value = code;
			//selectCode();
			
			if (!skipPlayerRefresh){
				dbPlayer_instances = undefined;
				
				new DBPlayer({
					station : (!form.station.value || form.station.value == "all")? "<?=$station ?>" : form.station.value,
					autoplay : form.autoplay.checked? "true" : "false",
					mode : form.mode.value,
					width : (form.mode.value == "large")? 600 : (form.miniCover.checked? 300 : 250),
					volume : form.volume.value,
					colors : form.colors.value,
					language : form.language.value
				}, "playerContainer");
			}
		}
		
		function selectCode(){
			var codeContainer = document.getElementById("codeContainer");
			codeContainer.focus();
			codeContainer.select();
		}
		
	</script>
	
</head>
<body>
	
<h2 style="margin-top: 0px;">Premium AAC+ Radio Player</h2>
	
	<div id="playerContainer" class="player"></div>	
	<script type="text/javascript"><!--
	var config = {
		defaultStation : "<?=$station ?>",
		autoplay : "true",
		mode : "large",
		containerId : "playerContainer"
	};
	//-->
	</script>
	<script type="text/javascript" src="<?=$basePath ?>/player.js?v=<?=filemtime("player.js") ?>"></script>
	
	<p>
		<strong>Tips:</strong>
		<ul>
			<li><strong>Click on the popup icon</strong> (bottom right) to open the full version on a separate window</li> 
			<li>Resize popup window to modify player size</li>
		</ul>	
	</p>
	
	<h3>Main Features</h3>
	<ul>
		<li>Allows playback of AAC+ streams directly from the streaming server, without need for any transcoding server (such as <strong>Wowza, FMS or Red5</strong>)</li> 
		<li>AAC+ allows high quality playback using low bandwidth, since an AAC+ stream requires less than half the bandwidth of an MP3 stream, for an equivalent listening quality</li>
		<li>Retrieves and parses station info, track history, and server/stream stats</li>
		<li>Pulls in album covers and info for each track automatically</li>
		<li>Built-in social buttons for viral marketing and contact form for user feedback</li>
		<li>Matched albums link directly to their respective page on the Amazon store</li>
		<li>Multiple station support, with the user able to switch stations without reloading</li>
		<li>Intuitive interface with tool tip integration on the ticker</li>
		<li>Multiple embeding options, including javascript, iframe and hot linking</li>
		<li>Fully scriptable, allows precise control from javascript, querystring or flashvars input</li>
		<li>Supports a wide array of broadcast servers and audio codecs</li>
		<li>Custom language packs allow localization for any language</li>
		<li>Includes an automatic proxy to bypass flash's over zealous security constraints, useful if the player is being served on a different server than the stream</li>
		<li>Android/iOS/Blackberry ports coming soon</li>
	</ul>	
	
	
	<h2>Embed the player on your site</h2>
	
	<h3>Step 1) Select the player's options:</h3> 
	
	<form id="embedForm">
		<p>
			Station: 
              <select name="station" onchange="refresh()">
                <?
				foreach ($stations as $value => $label)
					print '<option value="'.$value.'" '.($value == $station? 'selected' : '').'>'.$label.'</option>';
			?>
              </select>        
          <br/>
			Autoplay? <input type="checkbox" name="autoplay" onchange="refresh()" checked />
			<br/>
			Starting volume level? <input type="text" name="volume" onchange="refresh()" value="100" style="width: 30px;" />%
			<br/>
			Player type: 
			<select name="mode" onchange="refresh()">
				<option value="mini" >Mini</option>
				<option value="large" selected="selected">Full</option>
          </select>
			<br/>
			Color scheme: 
	        <select name="colors" onchange="refresh()">
              <option value="" selected>Default</option>
              <option value="secondaryColor=CA0404, backgroundColor=0x410101, primaryColor=#FF1717">Red</option>
              <option value="0x00FB0D, 0x007D06, 0x003503">Green</option>
              <option value="0x03AFE9, 0x02688A, 0x012936">Blue</option>
              <option value="0xFF9900, 0xAF6A03, 0x2E1C01">Orange</option>
              <option value="0xB7B7B7, 0x868686, -1">Grey</option>
              <option value="0, 0, 0xFFFFFF, -1, 0xFFFFFF, 0xFFFFFF">Black &amp; White</option>
              <option value="0xFF1717, 0xFFCC00, 0xFFFFFF, -1, 0xFFFFFF, 0xFFFFFF">Test</option>
                                    </select>	  
          <br/>
			Language: 
			<select name="language" onchange="refresh()">
				<option value="">Default</option>
				<option value="en" selected="selected">English</option>
				<option value="no">Norsk</option>
				<option value="pt">Portugu&ecirc;s</option>
				<option value="ro">Rom&acirc;n&#259;</option>
	    </select>
			<br/>
			Display album cover in mini version? <input type="checkbox" name="miniCover" onchange="refresh()" checked />
			<br/>
	  </p>
</form>
	<br/>
	
	
	<h3>Step 2) Copy & paste the following code on your site:</h3>
	<p>
	  <textarea name="codeContainer" cols="45" rows="5" id="codeContainer" onclick="selectCode()"></textarea>
	  <br/>
		<script type="text/javascript">refresh(true)</script>
		<button type="button" onclick="selectCode()">Select all code</button>
	</p>
<h3>Step 3) Include a link to <a href="http://www.hdustream.com" target="_blank">http://www.hdustream.com</a> on your site</h3>
	
	
	
	<h2>Premium Package</h2>
	<p>
		Purchase the premium version of the player for <strong>only $150</strong>, and get the following benefits:
<ul>
			<li>Stream <strong>any radio station</strong> you want</li>
			<li><strong>Remove ads</strong>, or replace them with your own</li>
			<li>Use your own Amazon affiliate id and <strong>start earning revenue</strong> on every sale</li>
			<li><strong>Remove any branding</strong>, or replace it with your own contacts/marketing material</li>
			<li><strong>Customize</strong> all of the text messages, and/or create a language pack in your own language</li>
			<li>Get <strong>priority support</strong> and more weight on feature requests</li>
			<li>Set a time limited trial and/or restrict to some domains</li>
			<li>Sleep better at night knowing you're supporting indie development ;)</li>
		</ul>
		
		<form name="_xclick" action="https://www.paypal.com/cgi-bin/webscr" method="post">
			<input type="hidden" name="cmd" value="_xclick">
			<input type="hidden" name="business" value="pagos@hdustream.com">
			<input type="hidden" name="currency_code" value="USD">
			<input type="hidden" name="item_name" value="Player Premium sin RTMP">
			<input type="hidden" name="amount" value="150">
			<input type="image" src="http://www.paypal.com/en_US/i/btn/btn_buynow_LG.gif" border="0" name="submit" alt="Purchase through Paypal">
		</form>
		<h2>Any questions?</h2>
	<p>
		Feel free to <a href="mailto:ventas@hdustream.com">drop us an email</a> with your enquiries.
	</p>
	
	
	<br/>
	<br/>
	Copyright &copy; <a href="http://www.hdustream.com" target="_blank">HDUstream.com.</a> - All Rights Reserved
	<br/>
	
</body>
</html>