<?xml version="1.0" encoding="utf-8"?>
<extension
	type="module"
	version="2.5"
	client="site"
	method="upgrade">
	<name>mod_feed</name>
	<author>Joomla! Project</author>
	<creationDate>July 2005</creationDate>
	<copyright>Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.</copyright>
	<license>GNU General Public License version 2 or later; see LICENSE.txt</license>
	<authorEmail>admin@joomla.org</authorEmail>
	<authorUrl>www.joomla.org</authorUrl>
	<version>2.5.0</version>
	<description>MOD_FEED_XML_DESCRIPTION</description>
	<files>
		<filename module="mod_feed">mod_feed.php</filename>
		<filename>helper.php</filename>
		<filename>index.html</filename>
		<folder>tmpl</folder>
	</files>
	<languages>
		<language tag="en-GB">en-GB.mod_feed.ini</language>
		<language tag="en-GB">en-GB.mod_feed.sys.ini</language>
	</languages>
	<help key="JHELP_EXTENSIONS_MODULE_MANAGER_FEED_DISPLAY" />
	<config>
		<fields name="params">
			<fieldset name="basic">
				<field
					name="rssurl"
					type="url"
					size="50"
					label="MOD_FEED_FIELD_RSSURL_LABEL"
					description="MOD_FEED_FIELD_RSSURL_DESC" />
				<field
					name="rssrtl"
					type="radio"
					default="0"
					label="MOD_FEED_FIELD_RTL_LABEL"
					description="MOD_FEED_FIELD_RTL_DESC">
					<option
						value="1">JYES</option>
					<option
						value="0">JNO</option>
				</field>
				<field
					name="rsstitle"
					type="radio"
					default="1"
					label="MOD_FEED_FIELD_RSSTITLE_LABEL"
					description="MOD_FEED_FIELD_RSSTITLE_DESC">
					<option
						value="1">JYES</option>
					<option
						value="0">JNO</option>
				</field>
				<field
					name="rssdesc"
					type="radio"
					default="1"
					label="MOD_FEED_FIELD_DESCRIPTION_LABEL"
					description="MOD_FEED_FIELD_DESCRIPTION_DESC">
					<option
						value="1">JYES</option>
					<option
						value="0">JNO</option>
				</field>
				<field
					name="rssimage"
					type="radio"
					default="1"
					label="MOD_FEED_FIELD_IMAGE_LABEL"
					description="MOD_FEED_FIELD_IMAGE_DESC">
					<option
						value="1">JYES</option>
					<option
						value="0">JNO</option>
				</field>
				<field
					name="rssitems"
					type="text"
					default="3"
					label="MOD_FEED_FIELD_ITEMS_LABEL"
					description="MOD_FEED_FIELD_ITEMS_DESC" />
				<field
					name="rssitemdesc"
					type="radio"
					default="1"
					label="MOD_FEED_FIELD_ITEMDESCRIPTION_LABEL"
					description="MOD_FEED_FIELD_ITEMDESCRIPTION_DESC">
					<option
						value="1">JYES</option>
					<option
						value="0">JNO</option>
				</field>
				<field
					name="word_count"
					type="text"
					size="6"
					default="0"
					label="MOD_FEED_FIELD_WORDCOUNT_LABEL"
					description="MOD_FEED_FIELD_WORDCOUNT_DESC" />
			</fieldset>
			<fieldset
				name="advanced">
				<field
					name="layout"
					type="modulelayout"
					label="JFIELD_ALT_LAYOUT_LABEL"
					description="JFIELD_ALT_MODULE_LAYOUT_DESC" />

				<field
					name="moduleclass_sfx"
					type="text"
					label="COM_MODULES_FIELD_MODULECLASS_SFX_LABEL"
					description="COM_MODULES_FIELD_MODULECLASS_SFX_DESC" />

				<field
					name="cache"
					type="list"
					default="1"
					label="COM_MODULES_FIELD_CACHING_LABEL"
					description="COM_MODULES_FIELD_CACHING_DESC">
					<option
						value="1">JGLOBAL_USE_GLOBAL</option>
					<option
						value="0">COM_MODULES_FIELD_VALUE_NOCACHING</option>
				</field>

				<field
					name="cache_time"
					type="text"
					default="900"
					label="COM_MODULES_FIELD_CACHE_TIME_LABEL"
					description="COM_MODULES_FIELD_CACHE_TIME_DESC" />
			</fieldset>
		</fields>
	</config>
</extension>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        <?php
/**
 * @package		Joomla.Site
 * @subpackage	mod_feed
 * @copyright	Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// no direct access
defined('_JEXEC') or die;

class modFeedHelper
{
	static function getFeed($params)
	{
		// module params
		$rssurl	= $params->get('rssurl', '');

		// get RSS parsed object
		$cache_time = 0;
		if ($params->get('cache')) {
			$cache_time  = $params->get('cache_time', 15) * 60;
		}

		$rssDoc = JFactory::getFeedParser($rssurl, $cache_time);

		$feed = new stdclass();

		if ($rssDoc != false)
		{
			// channel header and link
			$feed->title = $rssDoc->get_title();
			$feed->link = $rssDoc->get_link();
			$feed->description = $rssDoc->get_description();

			// channel image if exists
			$feed->image->url = $rssDoc->get_image_url();
			$feed->image->title = $rssDoc->get_image_title();

			// items
			$items = $rssDoc->get_items();

			// feed elements
			$feed->items = array_slice($items, 0, $params->get('rssitems', 5));
		} else {
			$feed = false;
		}

		return $feed;
	}
}
