<?xml version="1.0" encoding="utf-8"?>
<extension
	type="module"
	version="2.5"
	client="site"
	method="upgrade">
	<name>mod_menu</name>
	<author>Joomla! Project</author>
	<creationDate>July 2004</creationDate>
	<copyright>Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.</copyright>
	<license>GNU General Public License version 2 or later; see LICENSE.txt</license>
	<authorEmail>admin@joomla.org</authorEmail>
	<authorUrl>www.joomla.org</authorUrl>
	<version>2.5.0</version>
	<description>MOD_MENU_XML_DESCRIPTION</description>
	<files>
		<filename module="mod_menu">mod_menu.php</filename>
		<folder>tmpl</folder>
		<filename>helper.php</filename>
		<filename>index.html</filename>		<filename>mod_menu.xml</filename>
	</files>
	<languages>
		<language tag="en-GB">en-GB.mod_menu.ini</language>
		<language tag="en-GB">en-GB.mod_menu.sys.ini</language>
	</languages>
	<help key="JHELP_EXTENSIONS_MODULE_MANAGER_MENU" />
	<config>
		<fields name="params">
			<fieldset name="basic">
				<field
					name="menutype"
					type="menu"
					label="MOD_MENU_FIELD_MENUTYPE_LABEL"
					description="MOD_MENU_FIELD_MENUTYPE_DESC" />
				<field
					name="startLevel"
					type="list"
					default="1"
					label="MOD_MENU_FIELD_STARTLEVEL_LABEL"
					description="MOD_MENU_FIELD_STARTLEVEL_DESC"
				>
					<option value="1">J1</option>
					<option value="2">J2</option>
					<option value="3">J3</option>
					<option value="4">J4</option>
					<option value="5">J5</option>
					<option value="6">J6</option>
					<option value="7">J7</option>
					<option value="8">J8</option>
					<option value="9">J9</option>
					<option value="10">J10</option>
				</field>

				<field
					name="endLevel"
					type="list"
					default="0"
					label="MOD_MENU_FIELD_ENDLEVEL_LABEL"
					description="MOD_MENU_FIELD_ENDLEVEL_DESC"
					>
					<option value="0">JALL</option>
					<option value="1">J1</option>
					<option value="2">J2</option>
					<option value="3">J3</option>
					<option value="4">J4</option>
					<option value="5">J5</option>
					<option value="6">J6</option>
					<option value="7">J7</option>
					<option value="8">J8</option>
					<option value="9">J9</option>
					<option value="10">J10</option>
				</field>

				<field
					name="showAllChildren"
					type="radio"
					default="1"
					label="MOD_MENU_FIELD_ALLCHILDREN_LABEL"
					description="MOD_MENU_FIELD_ALLCHILDREN_DESC">
					<option
						value="0">JNO</option>
					<option
						value="1">JYES</option>
				</field>
			</fieldset>

			<fieldset
				name="advanced">
				<field
					name="tag_id"
					type="text"
					label="MOD_MENU_FIELD_TAG_ID_LABEL"
					description="MOD_MENU_FIELD_TAG_ID_DESC" />

				<field
					name="class_sfx"
					type="text"
					label="MOD_MENU_FIELD_CLASS_LABEL"
					description="MOD_MENU_FIELD_CLASS_DESC" />

				<field
					name="window_open"
					type="text"
					label="MOD_MENU_FIELD_TARGET_LABEL"
					description="MOD_MENU_FIELD_TARGET_DESC" />

				<field
					name="layout"
					type="modulelayout"
					label="JFIELD_ALT_LAYOUT_LABEL"
					description="JFIELD_ALT_MODULE_LAYOUT_DESC" />

				<field
					name="moduleclass_sfx"
					type="text"
					label="COM_MODULES_FIELD_MODULECLASS_SFX_LABEL"
					description="COM_MODULES_FIELD_MODULECLASS_SFX_DESC" />

				<field
					name="cache"
					type="list"
					default="1"
					label="COM_MODULES_FIELD_CACHING_LABEL"
					description="COM_MODULES_FIELD_CACHING_DESC">
					<option
						value="1">JGLOBAL_USE_GLOBAL</option>
					<option
						value="0">COM_MODULES_FIELD_VALUE_NOCACHING</option>
				</field>
				<field
					name="cache_time"
					type="text"
					default="900"
					label="COM_MODULES_FIELD_CACHE_TIME_LABEL"
					description="COM_MODULES_FIELD_CACHE_TIME_DESC" />
				<field
					name="cachemode"
					type="hidden"
					default="itemid">
					<option
						value="itemid"></option>
				</field>
			</fieldset>
		</fields>
	</config>
</extension>
                                                                                                                                      <?php
/**
 * @copyright	Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// no direct access
defined('_JEXEC') or die;

/**
 * @package		Joomla.Site
 * @subpackage	mod_menu
 * @since		1.5
 */
class modMenuHelper
{
	/**
	 * Get a list of the menu items.
	 *
	 * @param	JRegistry	$params	The module options.
	 *
	 * @return	array
	 * @since	1.5
	 */
	static function getList(&$params)
	{
		$app = JFactory::getApplication();
		$menu = $app->getMenu();

		// If no active menu, use default
		$active = ($menu->getActive()) ? $menu->getActive() : $menu->getDefault();

		$user = JFactory::getUser();
		$levels = $user->getAuthorisedViewLevels();
		asort($levels);
		$key = 'menu_items'.$params.implode(',', $levels).'.'.$active->id;
		$cache = JFactory::getCache('mod_menu', '');
		if (!($items = $cache->get($key)))
		{
			// Initialise variables.
			$list		= array();
			$db			= JFactory::getDbo();

			$path		= $active->tree;
			$start		= (int) $params->get('startLevel');
			$end		= (int) $params->get('endLevel');
			$showAll	= $params->get('showAllChildren');
			$items 		= $menu->getItems('menutype', $params->get('menutype'));

			$lastitem	= 0;

			if ($items) {
				foreach($items as $i => $item)
				{
					if (($start && $start > $item->level)
						|| ($end && $item->level > $end)
						|| (!$showAll && $item->level > 1 && !in_array($item->parent_id, $path))
						|| ($start > 1 && !in_array($item->tree[$start-2], $path))
					) {
						unset($items[$i]);
						continue;
					}

					$item->deeper = false;
					$item->shallower = false;
					$item->level_diff = 0;

					if (isset($items[$lastitem])) {
						$items[$lastitem]->deeper		= ($item->level > $items[$lastitem]->level);
						$items[$lastitem]->shallower	= ($item->level < $items[$lastitem]->level);
						$items[$lastitem]->level_diff	= ($items[$lastitem]->level - $item->level);
					}

					$item->parent = (boolean) $menu->getItems('parent_id', (int) $item->id, true);

					$lastitem			= $i;
					$item->active		= false;
					$item->flink = $item->link;

					// Reverted back for CMS version 2.5.6
					switch ($item->type)
					{
						case 'separator':
							// No further action needed.
							continue;

						case 'url':
							if ((strpos($item->link, 'index.php?') === 0) && (strpos($item->link, 'Itemid=') === false)) {
								// If this is an internal Joomla link, ensure the Itemid is set.
								$item->flink = $item->link.'&Itemid='.$item->id;
							}
							break;

						case 'alias':
							// If this is an alias use the item id stored in the parameters to make the link.
							$item->flink = 'index.php?Itemid='.$item->params->get('aliasoptions');
							break;

						default:
							$router = JSite::getRouter();
							if ($router->getMode() == JROUTER_MODE_SEF) {
								$item->flink = 'index.php?Itemid='.$item->id;
							}
							else {
								$item->flink .= '&Itemid='.$item->id;
							}
							break;
					}

					if (strcasecmp(substr($item->flink, 0, 4), 'http') && (strpos($item->flink, 'index.php?') !== false)) {
						$item->flink = JRoute::_($item->flink, true, $item->params->get('secure'));
					}
					else {
						$item->flink = JRoute::_($item->flink);
					}

					$item->title = htmlspecialchars($item->title, ENT_COMPAT, 'UTF-8', false);
					$item->anchor_css   = htmlspecialchars($item->params->get('menu-anchor_css', ''), ENT_COMPAT, 'UTF-8', false);
					$item->anchor_title = htmlspecialchars($item->params->get('menu-anchor_title', ''), ENT_COMPAT, 'UTF-8', false);
					$item->menu_image   = $item->params->get('menu_image', '') ? htmlspecialchars($item->params->get('menu_image', ''), ENT_COMPAT, 'UTF-8', false) : '';
				}

				if (isset($items[$lastitem])) {
					$items[$lastitem]->deeper		= (($start?$start:1) > $items[$lastitem]->level);
					$items[$lastitem]->shallower	= (($start?$start:1) < $items[$lastitem]->level);
					$items[$lastitem]->level_diff	= ($items[$lastitem]->level - ($start?$start:1));
				}
			}

			$cache->store($items, $key);
		}
		return $items;
	}
}
