<?php
/**
 * @package     Joomla.Libraries
 * @subpackage  Less
 *
 * @copyright   (C) 2014 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('JPATH_PLATFORM') or die;

/**
 * Formatter ruleset for Joomla formatted CSS generated via LESS
 *
 * @package     Joomla.Libraries
 * @subpackage  Less
 * @since       3.4
 * @deprecated  4.0  without replacement
 */
class JLessFormatterJoomla extends lessc_formatter_classic
{
	public $disableSingle = true;

	public $breakSelectors = true;

	public $assignSeparator = ': ';

	public $selectorSeparator = ',';

	public $indentChar = "\t";
}
                                                                                                                                                                                                                                                                                                                                                          <?php
/**
 * @package     Joomla.Libraries
 * @subpackage  Class
 *
 * @copyright   (C) 2014 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Composer\Autoload\ClassLoader;

/**
 * Decorate Composer ClassLoader for Joomla!
 *
 * For backward compatibility due to class aliasing in the CMS, the loadClass() method was modified to call
 * the JLoader::applyAliasFor() method.
 *
 * @since  3.4
 */
class JClassLoader
{
	/**
	 * The composer class loader
	 *
	 * @var    ClassLoader
	 * @since  3.4
	 */
	private $loader;

	/**
	 * Constructor
	 *
	 * @param   ClassLoader  $loader  Composer autoloader
	 *
	 * @since   3.4
	 */
	public function __construct(ClassLoader $loader)
	{
		$this->loader = $loader;
	}

	/**
	 * Loads the given class or interface.
	 *
	 * @param   string  $class  The name of the class
	 *
	 * @return  boolean|null  True if loaded, null otherwise
	 *
	 * @since   3.4
	 */
	public function loadClass($class)
	{
		if ($result = $this->loader->loadClass($class))
		{
			JLoader::applyAliasFor($class);
		}

		return $result;
	}
}
