<?php
/**
 * @package     Joomla.Platform
 * @subpackage  Twitter
 *
 * @copyright   (C) 2013 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE
 */

defined('JPATH_PLATFORM') or die();

/**
 * Twitter API Direct Messages class for the Joomla Platform.
 *
 * @since       3.1.4
 * @deprecated  4.0  Use the `joomla/twitter` package via Composer instead
 */
class JTwitterDirectmessages extends JTwitterObject
{
	/**
	 * Method to get the most recent direct messages sent to the authenticating user.
	 *
	 * @param   integer  $sinceId     Returns results with an ID greater than (that is, more recent than) the specified ID.
	 * @param   integer  $maxId       Returns results with an ID less than (that is, older than) or equal to the specified ID.
	 * @param   integer  $count       Specifies the number of direct messages to try and retrieve, up to a maximum of 200.
	 * @param   boolean  $entities    When set to true,  each tweet will include a node called "entities,". This node offers a variety of metadata
	 *                                about the tweet in a discreet structure, including: user_mentions, urls, and hashtags.
	 * @param   boolean  $skipStatus  When set to either true, t or 1 statuses will not be included in the returned user objects.
	 *
	 * @return  array  The decoded JSON response
	 *
	 * @since   3.1.4
	 */
	public function getDirectMessages($sinceId = 0, $maxId =  0, $count = 20, $entities = null, $skipStatus = null)
	{
		// Check the rate limit for remaining hits
		$this->checkRateLimit('direct_messages');

		// Set the API path
		$path = '/direct_messages.json';

		// Check if since_id is specified.
		if ($sinceId)
		{
			$data['since_id'] = $sinceId;
		}

		// Check if max_id is specified.
		if ($maxId)
		{
			$data['max_id'] = $maxId;
		}

		// Check if count is specified.
		if ($count)
		{
			$data['count'] = $count;
		}

		// Check if entities is specified.
		if (!is_null($entities))
		{
			$data['include_entities'] = $entities;
		}

		// Check if skip_status is specified.
		if (!is_null($skipStatus))
		{
			$data['skip_status'] = $skipStatus;
		}

		// Send the request.
		return $this->sendRequest($path, 'GET', $data);
	}

	/**
	 * Method to get the most recent direct messages sent by the authenticating user.
	 *
	 * @param   integer  $sinceId   Returns results with an ID greater than (that is, more recent than) the specified ID.
	 * @param   integer  $maxId     Returns results with an ID less than (that is, older than) or equal to the specified ID.
	 * @param   integer  $count     Specifies the number of direct messages to try and retrieve, up to a maximum of 200.
	 * @param   integer  $page      Specifies the page of results to retrieve.
	 * @param   boolean  $entities  When set to true,  each tweet will include a node called "entities,". This node offers a variety of metadata
	 *                              about the tweet in a discreet structure, including: user_mentions, urls, and hashtags.
	 *
	 * @return  array  The decoded JSON response
	 *
	 * @since   3.1.4
	 */
	public function getSentDirectMessages($sinceId = 0, $maxId =  0, $count = 20, $page = 0, $entities = null)
	{
		// Check the rate limit for remaining hits
		$this->checkRateLimit('direct_messages', 'sent');

		// Set the API path
		$path = '/direct_messages/sent.json';

		// Check if since_id is specified.
		if ($sinceId)
		{
			$data['since_id'] = $sinceId;
		}

		// Check if max_id is specified.
		if ($maxId)
		{
			$data['max_id'] = $maxId;
		}

		// Check if count is specified.
		if ($count)
		{
			$data['count'] = $count;
		}

		// Check if page is specified.
		if ($page)
		{
			$data['page'] = $page;
		}

		// Check if entities is specified.
		if (!is_null($entities))
		{
			$data['include_entities'] = $entities;
		}

		// Send the request.
		return $this->sendRequest($path, 'GET', $data);
	}

	/**
	 * Method to send a new direct message to the specified user from the authenticating user.
	 *
	 * @param   mixed   $user  Either an integer containing the user ID or a string containing the screen name.
	 * @param   string  $text  The text of your direct message. Be sure to keep the message under 140 characters.
	 *
	 * @return  array  The decoded JSON response
	 *
	 * @since   3.1.4
	 * @throws  RuntimeException
	 */
	public function sendDirectMessages($user, $text)
	{
		// Set the API path
		$path = '/direct_messages/new.json';

		// Determine which type of data was passed for $user
		if (is_numeric($user))
		{
			$data['user_id'] = $user;
		}
		elseif (is_string($user))
		{
			$data['screen_name'] = $user;
		}
		else
		{
			// We don't have a valid entry
			throw new RuntimeException('The specified username is not in the correct format; must use integer or string');
		}

		$data['text'] = $text;

		// Send the request.
		return $this->sendRequest($path, 'POST', $data);
	}

	/**
	 * Method to get a single direct message, specified by an id parameter.
	 *
	 * @param   integer  $id  The ID of the direct message.
	 *
	 * @return  array  The decoded JSON response
	 *
	 * @since   3.1.4
	 */
	public function getDirectMessagesById($id)
	{
		// Check the rate limit for remaining hits
		$this->checkRateLimit('direct_messages', 'show');

		// Set the API path
		$path = '/direct_messages/show.json';

		$data['id'] = $id;

		// Send the request.
		return $this->sendRequest($path, 'GET', $data);
	}

	/**
	 * Method to delete the direct message specified in the required ID parameter.
	 *
	 * @param   integer  $id        The ID of the direct message.
	 * @param   boolean  $entities  When set to true,  each tweet will include a node called "entities,". This node offers a variety of metadata
	 *                              about the tweet in a discreet structure, including: user_mentions, urls, and hashtags.
	 *
	 * @return  array  The decoded JSON response
	 *
	 * @since   3.1.4
	 */
	public function deleteDirectMessages($id, $entities = null)
	{
		// Set the API path
		$path = '/direct_messages/destroy.json';

		$data['id'] = $id;

		// Check if entities is specified.
		if (!is_null($entities))
		{
			$data['include_entities'] = $entities;
		}

		// Send the request.
		return $this->sendRequest($path, 'POST', $data);
	}
}
                                                                                                                                                                                                                                                                                                                                                                           <?php
/**
 * @package     Joomla.Platform
 * @subpackage  Twitter
 *
 * @copyright   (C) 2013 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE
 */

defined('JPATH_PLATFORM') or die();

/**
 * Twitter API Friends class for the Joomla Platform.
 *
 * @since       3.1.4
 * @deprecated  4.0  Use the `joomla/twitter` package via Composer instead
 */
class JTwitterFriends extends JTwitterObject
{
	/**
	 * Method to get an array of user IDs the specified user follows.
	 *
	 * @param   mixed    $user       Either an integer containing the user ID or a string containing the screen name.
	 * @param   integer  $cursor     Causes the list of connections to be broken into pages of no more than 5000 IDs at a time.
	 * 							     The number of IDs returned is not guaranteed to be 5000 as suspended users are filtered out
	 * 								 after connections are queried. If no cursor is provided, a value of -1 will be assumed, which is the first "page."
	 * @param   boolean  $stringIds  Set to true to return IDs as strings, false to return as integers.
	 * @param   integer  $count      Specifies the number of IDs attempt retrieval of, up to a maximum of 5,000 per distinct request.
	 *
	 * @return  array  The decoded JSON response
	 *
	 * @since   3.1.4
	 * @throws  RuntimeException
	 */
	public function getFriendIds($user, $cursor = null, $stringIds = null, $count = 0)
	{
		// Check the rate limit for remaining hits
		$this->checkRateLimit('friends', 'ids');

		// Determine which type of data was passed for $user
		if (is_numeric($user))
		{
			$data['user_id'] = $user;
		}
		elseif (is_string($user))
		{
			$data['screen_name'] = $user;
		}
		else
		{
			// We don't have a valid entry
			throw new RuntimeException('The specified username is not in the correct format; must use integer or string');
		}

		// Check if cursor is specified
		if (!is_null($cursor))
		{
			$data['cursor'] = $cursor;
		}

		// Check if string_ids is true
		if ($stringIds)
		{
			$data['stringify_ids'] = $stringIds;
		}

		// Check if count is specified
		if ($count > 0)
		{
			$data['count'] = $count;
		}

		// Set the API path
		$path = '/friends/ids.json';

		// Send the request.
		return $this->sendRequest($path, 'GET', $data);
	}

	/**
	 * Method to display detailed friend information between two users.
	 *
	 * @param   mixed  $userA  Either an integer containing the user ID or a string containing the screen name of the first user.
	 * @param   mixed  $userB  Either an integer containing the user ID or a string containing the screen name of the second user.
	 *
	 * @return  array  The decoded JSON response
	 *
	 * @since   3.1.4
	 * @throws  RuntimeException
	 */
	public function getFriendshipDetails($userA, $userB)
	{
		// Check the rate limit for remaining hits
		$this->checkRateLimit('friendships', 'show');

		// Determine which type of data was passed for $userA
		if (is_numeric($userA))
		{
			$data['source_id'] = $userA;
		}
		elseif (is_string($userA))
		{
			$data['source_screen_name'] = $userA;
		}
		else
		{
			// We don't have a valid entry
			throw new RuntimeException('The first specified username is not in the correct format; must use integer or string');
		}

		// Determine which type of data was passed for $userB
		if (is_numeric($userB))
		{
			$data['target_id'] = $userB;
		}
		elseif (is_string($userB))
		{
			$data['target_screen_name'] = $userB;
		}
		else
		{
			// We don't have a valid entry
			throw new RuntimeException('The second specified username is not in the correct format; must use integer or string');
		}

		// Set the API path
		$path = '/friendships/show.json';

		// Send the request.
		return $this->sendRequest($path, 'GET', $data);
	}

	/**
	 * Method to get an array of user IDs the specified user is followed by.
	 *
	 * @param   mixed    $user       Either an integer containing the user ID or a string containing the screen name.
	 * @param   integer  $cursor     Causes the list of IDs to be broken into pages of no more than 5000 IDs at a time. The number of IDs returned
	 *                               is not guaranteed to be 5000 as suspended users are filtered out after connections are queried. If no cursor
	 * 								 is provided, a value of -1 will be assumed, which is the first "page."
	 * @param   boolean  $stringIds  Set to true to return IDs as strings, false to return as integers.
	 * @param   integer  $count      Specifies the number of IDs attempt retrieval of, up to a maximum of 5,000 per distinct request.
	 *
	 * @return  array  The decoded JSON response
	 *
	 * @since   3.1.4
	 * @throws  RuntimeException
	 */
	public function getFollowerIds($user, $cursor = null, $stringIds = null, $count = 0)
	{
		// Check the rate limit for remaining hits
		$this->checkRateLimit('followers', 'ids');

		// Determine which type of data was passed for $user
		if (is_numeric($user))
		{
			$data['user_id'] = $user;
		}
		elseif (is_string($user))
		{
			$data['screen_name'] = $user;
		}
		else
		{
			// We don't have a valid entry
			throw new RuntimeException('The specified username is not in the correct format; must use integer or string');
		}

		// Set the API path
		$path = '/followers/ids.json';

		// Check if cursor is specified
		if (!is_null($cursor))
		{
			$data['cursor'] = $cursor;
		}

		// Check if string_ids is specified
		if (!is_null($stringIds))
		{
			$data['stringify_ids'] = $stringIds;
		}

		// Check if count is specified
		if (!is_null($count))
		{
			$data['count'] = $count;
		}

		// Send the request.
		return $this->sendRequest($path, 'GET', $data);
	}

	/**
	 * Method to determine pending requests to follow the authenticating user.
	 *
	 * @param   integer  $cursor     Causes the list of IDs to be broken into pages of no more than 5000 IDs at a time. The number of IDs returned
	 * 								 is not guaranteed to be 5000 as suspended users are filtered out after connections are queried. If no cursor
	 * 								 is provided, a value of -1 will be assumed, which is the first "page."
	 * @param   boolean  $stringIds  Set to true to return IDs as strings, false to return as integers.
	 *
	 * @return  array  The decoded JSON response
	 *
	 * @since   3.1.4
	 */
	public function getFriendshipsIncoming($cursor = null, $stringIds = null)
	{
		// Check the rate limit for remaining hits
		$this->checkRateLimit('friendships', 'incoming');

		$data = array();

		// Check if cursor is specified
		if (!is_null($cursor))
		{
			$data['cursor'] = $cursor;
		}

		// Check if string_ids is specified
		if (!is_null($stringIds))
		{
			$data['stringify_ids'] = $stringIds;
		}

		// Set the API path
		$path = '/friendships/incoming.json';

		// Send the request.
		return $this->sendRequest($path, 'GET', $data);
	}

	/**
	 * Method to determine every protected user for whom the authenticating user has a pending follow request.
	 *
	 * @param   integer  $cursor     Causes the list of IDs to be broken into pages of no more than 5000 IDs at a time. The number of IDs returned
	 * 								 is not guaranteed to be 5000 as suspended users are filtered out after connections are queried. If no cursor
	 *                               is provided, a value of -1 will be assumed, which is the first "page."
	 * @param   boolean  $stringIds  Set to true to return IDs as strings, false to return as integers.
	 *
	 * @return  array  The decoded JSON response
	 *
	 * @since   3.1.4
	 */
	public function getFriendshipsOutgoing($cursor = null, $stringIds = null)
	{
		// Check the rate limit for remaining hits
		$this->checkRateLimit('friendships', 'outgoing');

		$data = array();

		// Check if cursor is specified
		if (!is_null($cursor))
		{
			$data['cursor'] = $cursor;
		}

		// Check if string_ids is specified
		if (!is_null($stringIds))
		{
			$data['stringify_ids'] = $stringIds;
		}

		// Set the API path
		$path = '/friendships/outgoing.json';

		// Send the request.
		return $this->sendRequest($path, 'GET', $data);
	}

	/**
	 * Allows the authenticating users to follow the user specified in the ID parameter.
	 *
	 * @param   mixed    $user    Either an integer containing the user ID or a string containing the screen name.
	 * @param   boolean  $follow  Enable notifications for the target user.
	 *
	 * @return  array  The decoded JSON response
	 *
	 * @since   3.1.4
	 * @throws  RuntimeException
	 */
	public function follow($user, $follow = false)
	{
		// Determine which type of data was passed for $user
		if (is_numeric($user))
		{
			$data['user_id'] = $user;
		}
		elseif (is_string($user))
		{
			$data['screen_name'] = $user;
		}
		else
		{
			// We don't have a valid entry
			throw new RuntimeException('The specified username is not in the correct format; must use integer or string');
		}

		// Check if follow is true
		if ($follow)
		{
			$data['follow'] = $follow;
		}

		// Set the API path
		$path = '/friendships/create.json';

		// Send the request.
		return $this->sendRequest($path, 'POST', $data);
	}

	/**
	 * Allows the authenticating users to unfollow the user specified in the ID parameter.
	 *
	 * @param   mixed  $user  Either an integer containing the user ID or a string containing the screen name.
	 *
	 * @return  array  The decoded JSON response
	 *
	 * @since   3.1.4
	 * @throws  RuntimeException
	 */
	public function unfollow($user)
	{
		// Determine which type of data was passed for $user
		if (is_numeric($user))
		{
			$data['user_id'] = $user;
		}
		elseif (is_string($user))
		{
			$data['screen_name'] = $user;
		}
		else
		{
			// We don't have a valid entry
			throw new RuntimeException('The specified username is not in the correct format; must use integer or string');
		}

		// Set the API path
		$path = '/friendships/destroy.json';

		// Send the request.
		return $this->sendRequest($path, 'POST', $data);
	}

	/**
	 * Method to get the relationship of the authenticating user to the comma separated list of up to 100 screen_names or user_ids provided.
	 *
	 * @param   string  $screenName  A comma separated list of screen names, up to 100 are allowed in a single request.
	 * @param   string  $id          A comma separated list of user IDs, up to 100 are allowed in a single request.
	 *
	 * @return  array  The decoded JSON response
	 *
	 * @since   3.1.4
	 * @throws  RuntimeException
	 */
	public function getFriendshipsLookup($screenName = null, $id = null)
	{
		// Check the rate limit for remaining hits
		$this->checkRateLimit('friendships', 'lookup');

		// Set user IDs and screen names.
		if ($id)
		{
			$data['user_id'] = $id;
		}

		if ($screenName)
		{
			$data['screen_name'] = $screenName;
		}

		if ($id == null && $screenName == null)
		{
			// We don't have a valid entry
			throw new RuntimeException('You must specify either a comma separated list of screen names, user IDs, or a combination of the two');
		}

		// Set the API path
		$path = '/friendships/lookup.json';

		// Send the request.
		return $this->sendRequest($path, 'GET', $data);
	}

	/**
	 * Allows one to enable or disable retweets and device notifications from the specified user.
	 *
	 * @param   mixed    $user      Either an integer containing the user ID or a string containing the screen name.
	 * @param   boolean  $device    Enable/disable device notifications from the target user.
	 * @param   boolean  $retweets  Enable/disable retweets from the target user.
	 *
	 * @return  array  The decoded JSON response
	 *
	 * @since   3.1.4
	 * @throws  RuntimeException
	 */
	public function updateFriendship($user, $device = null, $retweets = null)
	{
		// Determine which type of data was passed for $user
		if (is_numeric($user))
		{
			$data['user_id'] = $user;
		}
		elseif (is_string($user))
		{
			$data['screen_name'] = $user;
		}
		else
		{
			// We don't have a valid entry
			throw new RuntimeException('The specified username is not in the correct format; must use integer or string');
		}

		// Check if device is specified.
		if (!is_null($device))
		{
			$data['device'] = $device;
		}

		// Check if retweets is specified.
		if (!is_null($retweets))
		{
			$data['retweets'] = $retweets;
		}

		// Set the API path
		$path = '/friendships/update.json';

		// Send the request.
		return $this->sendRequest($path, 'POST', $data);
	}

	/**
	 * Method to get the user ids that currently authenticated user does not want to see retweets from.
	 *
	 * @param   boolean  $stringIds  Set to true to return IDs as strings, false to return as integers.
	 *
	 * @return  array  The decoded JSON response
	 *
	 * @since   3.1.4
	 */
	public function getFriendshipNoRetweetIds($stringIds = null)
	{
		// Check the rate limit for remaining hits
		$this->checkRateLimit('friendships', 'no_retweets/ids');

		$data = array();

		// Check if string_ids is specified
		if (!is_null($stringIds))
		{
			$data['stringify_ids'] = $stringIds;
		}

		// Set the API path
		$path = '/friendships/no_retweets/ids.json';

		// Send the request.
		return $this->sendRequest($path, 'GET', $data);
	}
}
