(function($,window,document,undefined){var pluginName="searchtools";var defaults={formSelector:".js-stools-form",searchFieldSelector:".js-stools-field-search",clearBtnSelector:".js-stools-btn-clear",mainContainerSelector:".js-stools",searchBtnSelector:".js-stools-btn-search",filterBtnSelector:".js-stools-btn-filter",filterContainerSelector:".js-stools-container-filters",filtersHidden:true,listBtnSelector:".js-stools-btn-list",listContainerSelector:".js-stools-container-list",listHidden:false,orderColumnSelector:".js-stools-column-order",orderBtnSelector:".js-stools-btn-order",orderFieldSelector:".js-stools-field-order",orderFieldName:"list[fullordering]",limitFieldSelector:".js-stools-field-limit",defaultLimit:20,activeOrder:null,activeDirection:"ASC",chosenSupport:true,clearListOptions:false};function Plugin(element,options){this.element=element;this.options=$.extend({},defaults,options);this._defaults=defaults;this.theForm=$(this.options.formSelector);this.filterButton=$(this.options.formSelector+" "+this.options.filterBtnSelector);this.filterContainer=$(this.options.formSelector+" "+this.options.filterContainerSelector);this.filtersHidden=this.options.filtersHidden;this.listButton=$(this.options.formSelector+" "+this.options.listBtnSelector);this.listContainer=$(this.options.formSelector+" "+this.options.listContainerSelector);this.listHidden=this.options.listHidden;this.mainContainer=$(this.options.mainContainerSelector);this.searchButton=$(this.options.formSelector+" "+this.options.searchBtnSelector);this.searchField=$(this.options.formSelector+" "+this.options.searchFieldSelector);this.searchString=null;this.clearButton=$(this.options.clearBtnSelector);this.orderCols=$(this.options.formSelector+" "+this.options.orderColumnSelector);this.orderField=$(this.options.formSelector+" "+this.options.orderFieldSelector);this.limitField=$(this.options.formSelector+" "+this.options.limitFieldSelector);this.activeColumn=null;this.activeDirection=this.options.activeDirection;this.activeOrder=this.options.activeOrder;this.activeLimit=null;this.chosenSupport=this.options.chosenSupport;this.clearListOptions=this.options.clearListOptions;this._name=pluginName;this.init()}Plugin.prototype={init:function(){var self=this;if(!document.addEventListener){if(this.searchField.val()===this.searchField.attr("placeholder")){this.searchField.val("")}}this.searchString=this.searchField.val();if(this.filtersHidden){this.hideFilters()}else{this.showFilters()}if(this.listHidden){this.hideList()}else{this.showList()}self.filterButton.click(function(e){self.toggleFilters();e.stopPropagation();e.preventDefault()});self.listButton.click(function(e){self.toggleList();e.stopPropagation();e.preventDefault()});self.getFilterFields().each(function(i,element){self.checkFilter(element);$(element).change(function(){self.checkFilter(element)})});self.clearButton.click(function(e){self.clear()});this.createOrderField();this.orderCols.click(function(){var newOrderCol=$(this).attr("data-order");var newDirection=$(this).attr('data-direction');var newOrdering=newOrderCol+" "+newDirection;if(newOrderCol.length){self.activeColumn=newOrderCol;if(newOrdering!==self.activeOrder){self.activeDirection=newDirection;self.activeOrder=newOrdering;self.updateFieldValue(self.orderField,newOrdering)}else{self.toggleDirection()}self.theForm.submit()}})},checkFilter:function(element){var self=this;var option=$(element).find("option:selected");if(option.val()!==""){self.activeFilter(element)}else{self.deactiveFilter(element)}},clear:function(){var self=this;self.getFilterFields().each(function(i,element){$(element).val("");self.checkFilter(element);if(self.chosenSupport){$(element).trigger("liszt:updated")}});if(self.clearListOptions){self.getListFields().each(function(i,element){$(element).val("");self.checkFilter(element);if(self.chosenSupport){$(element).trigger("liszt:updated")}});$("#list_limit").val(self.options.defaultLimit);if(self.chosenSupport){$("#list_limit").trigger("liszt:updated")}}self.searchField.val("");self.theForm.submit()},activeFilter:function(element){var self=this;$(element).addClass("active");var chosenId="#"+$(element).attr("id")+"_chzn";$(chosenId).addClass("active")},deactiveFilter:function(element){var self=this;$(element).removeClass("active");var chosenId="#"+$(element).attr("id")+"_chzn";$(chosenId).removeClass("active")},getFilterFields:function(){return this.filterContainer.find("select,input")},getListFields:function(){return this.listContainer.find("select")},hideContainer:function(container){$(container).hide("fast");$(container).removeClass("shown")},showContainer:function(container){$(container).show("fast");$(container).addClass("shown")},toggleContainer:function(container){if($(container).hasClass("shown")){this.hideContainer(container)}else{this.showContainer(container)}},hideList:function(){this.hideContainer(this.listContainer);this.listButton.removeClass("btn-primary")},showList:function(){this.showContainer(this.listContainer);this.listButton.addClass("btn-primary")},toggleList:function(){this.toggleContainer(this.listContainer);if(this.listContainer.hasClass("shown")){this.listButton.addClass("btn-primary")}else{this.listButton.removeClass("btn-primary")}},hideFilters:function(){this.hideContainer(this.filterContainer);this.filterButton.removeClass("btn-primary")},showFilters:function(){this.showContainer(this.filterContainer);this.filterButton.addClass("btn-primary")},toggleFilters:function(){this.toggleContainer(this.filterContainer);if(this.filterContainer.hasClass("shown")){this.filterButton.addClass("btn-primary")}else{this.filterButton.removeClass("btn-primary")}},toggleDirection:function(){var self=this;var newDirection="ASC";if(self.activeDirection.toUpperCase()=="ASC"){newDirection="DESC"}self.activeDirection=newDirection;self.activeOrder=self.activeColumn+" "+newDirection;self.updateFieldValue(self.orderField,self.activeOrder)},createOrderField:function(){var self=this;if(!this.orderField.length){this.orderField=$("<input>").attr({type:"hidden",id:"js-stools-field-order","class":"js-stools-field-order",name:self.options.orderFieldName,value:self.activeOrder+" "+this.activeDirection});this.orderField.appendTo(this.theForm)}if(this.orderField.is("select")){this.orderCols.each(function(){var value=$(this).attr("data-order");var name=$(this).attr("data-name");var direction=$(this).attr("data-direction");if(value.length){value=value+" "+direction;var option=self.findOption(self.orderField,value);if(!option.length){var option=$("<option>");option.text(name).val(value);if($(this).hasClass("active")){option.attr("selected","selected")}self.orderField.append(option)}}});this.orderField.trigger("liszt:updated")}this.activeOrder=this.orderField.val()},updateFieldValue:function(field,newValue){var self=this;var type=field.attr("type");if(type==="hidden"||type==="text"){field.attr("value",newValue)}else if(field.is("select")){var desiredOption=field.find("option").filter(function(){return $(this).val()==newValue});if(desiredOption.length){desiredOption.attr("selected","selected")}else{var option=$("<option>");option.text(newValue).val(newValue);option.attr("selected","selected");field.append(option)}if(self.chosenSupport){field.trigger("liszt:updated")}}},findOption:function(select,value){return select.find("option").filter(function(){return $(this).val()==value})}};$.fn[pluginName]=function(options){return this.each(function(){if(!$.data(this,"plugin_"+pluginName)){$.data(this,"plugin_"+pluginName,new Plugin(this,options))}})}})(jQuery,window,document);                                                                                                    /**
 * LOOSELY BASED ON:
 * Very simple jQuery Color Picker
 * Copyright (C) 2012 Tanguy Krotoff
 * Licensed under the MIT license
 *
 * ADAPTED BY:
 * Copyright (C) 2013 Peter van Westen
 *
 * MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

(function($) {
	var SimpleColorPicker = function(element, options) {
		this.select = $(element);
		this.options = $.extend({}, $.fn.simplecolors.defaults, options);

		this.select.hide();

		// Build the list of colors
		var list = '';
		$('option', this.select).each(function() {
			var option = $(this);
			var color = option.val();
			if (option.text() == '-') {
				list += '<br />';
			} else {
				var clss = 'simplecolors-swatch';
				if (color == 'none') {
					clss += ' nocolor';
					color = 'transparent';
				}
				if (option.attr('selected')) {
					clss += ' active';
				}
				list += '<span class="' + clss + '"><span style="background-color: ' + color + ';" tabindex="0"></span></span>';
			}
		});

		var color = this.select.val();
		var clss = 'simplecolors-swatch';
		if (color == 'none') {
			clss += ' nocolor';
			color = 'transparent';
		}
		this.icon = $('<span class="' + clss + '"><span style="background-color: ' + color + ';" tabindex="0"></span></span>').insertAfter(this.select);
		this.icon.on('click', $.proxy(this.show, this));

		this.panel = $('<span class="simplecolors-panel"></span>').appendTo(document.body);
		this.panel.html(list);
		this.panel.on('click', $.proxy(this.click, this));

		// Hide panel when clicking outside
		$(document).on('mousedown', $.proxy(this.hide, this));
		this.panel.on('mousedown', $.proxy(this.mousedown, this));

	};

	/**
	 * SimpleColorPicker class
	 */
	SimpleColorPicker.prototype = {
		constructor: SimpleColorPicker,

		show: function() {
			var panelpadding = 7; // Empirical value
			var pos = this.icon.offset();
			switch (this.select.attr('data-position')) {
				case 'top':
					this.panel.css({
						left: pos.left - panelpadding,
						top: pos.top - this.panel.outerHeight() - 1
					});
					break;
				case 'bottom':
					this.panel.css({
						left: pos.left - panelpadding,
						top: pos.top + this.icon.outerHeight()
					});
					break;
				case 'left':
					this.panel.css({
						left: pos.left - this.panel.outerWidth(),
						top: pos.top - ( (this.panel.outerHeight() - this.icon.outerHeight() ) / 2 ) - 1
					});
					break;
				case 'right':
				default:
					this.panel.css({
						left: pos.left + this.icon.outerWidth(),
						top: pos.top - ( (this.panel.outerHeight() - this.icon.outerHeight() ) / 2 ) - 1
					});
					break;
			}

			this.panel.show(this.options.delay);
		},

		hide: function() {
			if (this.panel.css('display') != 'none') {
				this.panel.hide(this.options.delay);
			}
		},

		click: function(e) {
			var target = $(e.target);
			if (target.length === 1) {
				if (target[0].nodeName.toLowerCase() === 'span') {
					// When you click on a color

					var color = '';
					var bgcolor = '';
					var clss = '';
					if (target.parent().hasClass('nocolor')) {
						color = 'none';
						bgcolor = 'transparent';
						clss = 'nocolor';
					} else {
						color = this.rgb2hex(target.css('background-color'));
						bgcolor = color;
					}

					// Mark this div as the selected one
					target.parent().siblings().removeClass('active');
					target.parent().addClass('active');

					this.icon.removeClass('nocolor').addClass(clss);
					this.icon.find('span').css('background-color', bgcolor);

					// Hide the panel
					this.hide();

					// Change select value
					this.select.val(color).change();
				}
			}
		},

		/**
		 * Prevents the mousedown event from "eating" the click event.
		 */
		mousedown: function(e) {
			e.stopPropagation();
			e.preventDefault();
		},

		/**
		 * Converts a RGB color to its hexadecimal value.
		 *
		 * See http://stackoverflow.com/questions/1740700/get-hex-value-rather-than-rgb-value-using-$
		 */
		rgb2hex: function(rgb) {
			function hex(x) {
				return ("0" + parseInt(x, 10).toString(16)).slice(-2);
			}

			var matches = rgb.match(/^rgb\((\d+),\s*(\d+),\s*(\d+)\)$/);
			if (matches === null) {
				// Fix for Internet Explorer < 9
				// Variable rgb is already a hexadecimal value
				return rgb;
			} else {
				return '#' + hex(matches[1]) + hex(matches[2]) + hex(matches[3]);
			}
		}
	};

	/**
	 * Plugin definition.
	 */
	$.fn.simplecolors = function(option) {
		// For HTML element passed to the plugin
		return this.each(function() {
			var $this = $(this),
				data = $this.data('simplecolors'),
				options = typeof option === 'object' && option;
			if (!data) {
				$this.data('simplecolors', (data = new SimpleColorPicker(this, options)));
			}
			if (typeof option === 'string') {
				data[option]();
			}
		});
	};

	$.fn.simplecolors.Constructor = SimpleColorPicker;

	/**
	 * Default options.
	 */
	$.fn.simplecolors.defaults = {
		// Animation delay
		delay: 0
	};
})(jQuery);
