/**
 * @package     Joomla.JavaScript
 * @copyright   (C) 2011 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

// Only define the Joomla namespace if not defined.
if (typeof(Joomla) === 'undefined') {
    var Joomla = {};
}

Joomla.Highlighter = function(_options){
    var $, words, options = {
        autoUnhighlight: true,
        caseSensitive: false,
        startElement: false,
        endElement: false,
        elements: [],
        className: 'highlight',
        onlyWords: true,
        tag: 'span'
    },

    highlight = function (words) {
        if (words.constructor === String) {
            words = [words];
        }
        if (options.autoUnhighlight) {
            unhighlight(words);
        }
        var pattern = options.onlyWords ? '\b' + pattern + '\b' : '(' + words.join('\\b|\\b') + ')',
        regex = new RegExp(pattern, options.caseSensitive ? '' : 'i');
        options.elements.map(function(el){
            recurse(el, regex, options.className);
        });
        return this;
    },

    unhighlight = function (words) {
        if (words.constructor === String) {
            words = [words];
        }

        var $elements, tn;
        words.map(function(word){
            word = (options.caseSensitive ? word : word.toUpperCase());
            if (words[word]) {
                $elements = $(words[word]);
                $elements.removeClass();
                $elements.each(function (index, el) {
                    tn = document.createTextNode($(el).text());
                    el.parentNode.replaceChild(tn, el);
                });
            }
        });
        return this;
    },

    recurse = function (node, regex, klass) {
        if (node.nodeType === 3) {
            var match = node.nodeValue.match(regex), highlight, $highlight, wordNode, wordClone, comparer, i;
            if (match) {
                highlight = document.createElement(options.tag);
                $highlight = $(highlight);
                $highlight.addClass(klass);
                wordNode = node.splitText(match.index);
                wordNode.splitText(match[0].length);
                wordClone = wordNode.cloneNode(true);
                $highlight.append(wordClone);
                $(wordNode).replaceWith(highlight)
                $highlight.attr('rel', $highlight.text());
                comparer = $highlight.text()
                if (!options.caseSensitive) {
                    comparer = $highlight.text().toUpperCase();
                }
                if (!words[comparer]) {
                    words[comparer] = [];
                }
                words[comparer].push(highlight);
                return 1;
            }
        } else if ((node.nodeType === 1 && node.childNodes) && !/(script|style|textarea|iframe)/i.test(node.tagName) && !(node.tagName === options.tag.toUpperCase() && node.className === klass)) {
            for (i = 0; i < node.childNodes.length; i++) {
                i += recurse(node.childNodes[i], regex, klass);
            }
        }
        return 0;
    },

    getElements = function ($start, $end) {
        var $next = $start.next();
        if ($next.attr('id') !== $end.attr('id')) {
            options.elements.push($next.get(0));
            getElements($next, $end);
        }
    },

    initialize = function(_options) {
        $ = jQuery.noConflict();
        $.extend(options, _options);
        getElements($(options.startElement), $(options.endElement));
        words = [];
    };

    initialize(_options);

    return {
        highlight: highlight,
        unhighlight : unhighlight
    };
}
                                                                                                                                                                                                                                                                                                                                                                                                       (function($){"use strict";$.subformRepeatable=function(container,options){this.$container=$(container);var self=this;if(this.$container.data("subformRepeatable")){return self}this.$container.data("subformRepeatable",self);this.options=$.extend({},$.subformRepeatable.defaults,options);this.template="";this.prepareTemplate();this.$containerRows=this.options.rowsContainer?this.$container.find(this.options.rowsContainer):this.$container;this.lastRowNum=this.$containerRows.find(this.options.repeatableElement).length;this.$container.on("click",this.options.btAdd,function(e){e.preventDefault();var after=$(this).parents(self.options.repeatableElement);if(!after.length){after=null}self.addRow(after)});this.$container.on("click",this.options.btRemove,function(e){e.preventDefault();var $row=$(this).parents(self.options.repeatableElement);self.removeRow($row)});if(this.options.btMove){this.$containerRows.sortable({items:this.options.repeatableElement,handle:this.options.btMove,tolerance:"pointer"})}this.$container.trigger("subform-ready")};$.subformRepeatable.prototype.prepareTemplate=function(){if(this.options.rowTemplateSelector){var $tmplElement=this.$container.find(this.options.rowTemplateSelector).last();this.template=$.trim($tmplElement.html())||"";$tmplElement.css("display","none");var map={SUBFORMLT:"<",SUBFORMGT:">"};this.template=this.template.replace(/(SUBFORMLT)|(SUBFORMGT)/g,function(match){return map[match]})}else{var row=this.$container.find(this.options.repeatableElement).get(0),$row=$(row).clone();try{this.clearScripts($row)}catch(e){if(window.console){console.log(e)}}this.template=$row.prop("outerHTML")}};$.subformRepeatable.prototype.addRow=function(after){var count=this.$containerRows.find(this.options.repeatableElement).length;if(count>=this.options.maximum){return null}var row=$.parseHTML(this.template);if(after){$(after).after(row)}else{this.$containerRows.append(row)}var $row=$(row);$row.attr("data-new","true");this.fixUniqueAttributes($row,count);try{this.fixScripts($row)}catch(e){if(window.console){console.log(e)}}this.$container.trigger("subform-row-add",$row);return $row};$.subformRepeatable.prototype.removeRow=function($row){var count=this.$containerRows.find(this.options.repeatableElement).length;if(count<=this.options.minimum){return}this.$container.trigger("subform-row-remove",$row);$row.remove()};$.subformRepeatable.prototype.fixUniqueAttributes=function($row,_count,_group,_basename,isNested){var group=typeof _group==="undefined"?$row.attr("data-group"):_group,basename=typeof _basename==="undefined"?$row.attr("data-base-name"):_basename,count=typeof _count==="undefined"?0:_count,countnew=Math.max(this.lastRowNum,count),groupnew=basename+countnew;$row.attr("data-group",groupnew);var haveName=$row.find("[name]"),ids={};for(var i=0,l=haveName.length;i<l;i++){var $el=$(haveName[i]),name=$el.attr("name"),id=name.replace(/(\[\]$)/g,"").replace(/(\]\[)/g,"__").replace(/\[/g,"_").replace(/\]/g,""),nameNew=name.replace("["+group+"][","["+groupnew+"]["),idNew=id.replace(group,groupnew).replace(/\W/g,"_"),countMulti=0,forOldAttr=id;if($el.prop("type")==="checkbox"&&name.match(/\[\]$/)){countMulti=ids[id]?ids[id].length:0;if(!countMulti){$el.closest("fieldset.checkboxes").attr("id",idNew);$row.find('label[for="'+id+'"]').attr("for",idNew).attr("id",idNew+"-lbl")}forOldAttr=forOldAttr+countMulti;idNew=idNew+countMulti}else if($el.prop("type")==="radio"){countMulti=ids[id]?ids[id].length:0;if(!countMulti){$el.closest("fieldset.radio").attr("id",idNew);$row.find('label[for="'+id+'"]').attr("for",idNew).attr("id",idNew+"-lbl")}forOldAttr=forOldAttr+countMulti;idNew=idNew+countMulti}if(ids[id]){ids[id].push(true)}else{ids[id]=[true]}$el.attr("name",nameNew);$el.attr("id",idNew);$row.find('label[for="'+forOldAttr+'"]').attr("for",idNew).attr("id",idNew+"-lbl")}var nestedTemplates=$row.find(this.options.rowTemplateSelector);for(var j=0;j<nestedTemplates.length;j++){var nestedTemplate=$($(nestedTemplates[j]).prop("content"));this.fixUniqueAttributes(nestedTemplate,count,group,basename,true)}if(!isNested){this.lastRowNum=countnew+1}};$.subformRepeatable.prototype.clearScripts=function($row){if($.fn.chosen){$row.find("select.chzn-done").each(function(){var $el=$(this);$el.next(".chzn-container").remove();$el.show().addClass("fix-chosen")})}};$.subformRepeatable.prototype.fixScripts=function($row){$row.find('a[onclick*="jInsertFieldValue"]').each(function(){var $el=$(this),inputId=$el.siblings('input[type="text"]').attr("id"),$select=$el.prev(),oldHref=$select.attr("href");$el.attr("onclick","jInsertFieldValue('', '"+inputId+"');return false;");$select.attr("href",oldHref.replace(/&fieldid=(.+)&/,"&fieldid="+inputId+"&"))})};$.subformRepeatable.defaults={btAdd:".group-add",btRemove:".group-remove",btMove:".group-move",minimum:0,maximum:10,repeatableElement:".subform-repeatable-group",rowTemplateSelector:"template.subform-repeatable-template-section",rowsContainer:null};$.fn.subformRepeatable=function(options){return this.each(function(){var options=options||{},data=$(this).data();if(data.subformRepeatable){return}for(var p in data){if(data.hasOwnProperty(p)){options[p]=data[p]}}var inst=new $.subformRepeatable(this,options);$(this).data("subformRepeatable",inst)})};$(function($){initSubform();$(document).on("subform-row-add",initSubform);function initSubform(event,container){$(container||document).find("div.subform-repeatable").subformRepeatable()}})})(jQuery);
