/**
 * @copyright   (C) 2010 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

/**
 * Switcher behavior
 *
 * @package     Joomla
 * @since       1.5
 */
var JSwitcher = function(toggler, element, _options) {
    var $, $togglers, $elements, current, options = {
        onShow : function() {
        },
        onHide : function() {
        },
        cookieName : 'switcher',
        togglerSelector : 'a',
        elementSelector : 'div.tab',
        elementPrefix : 'page-'
    },

    initialize = function(toggler, element, _options) {
        $ = jQuery.noConflict();
        $.extend(options, _options);

        $togglers = $(toggler).find(options.togglerSelector);
        $elements = $(element).find(options.elementSelector);

        if (($togglers.length === 0) || ($togglers.length !== $elements.length)) {
            return;
        }

        hideAll();

        $togglers.each(function() {
            $(this).on('click', function() {
                display($(this).attr('id'));
            });
        })

        var first = document.location.hash.substring(1);
        if (first) {
            display(first);
        } else if ($togglers.length) {
            display($togglers.first().attr('id'));
        }
    },

    display = function(togglerId) {
        var $toggler = $('#' + togglerId), $element = $('#' + options.elementPrefix + togglerId);

        if ($toggler.length === 0 || $element.length === 0 || togglerId === current) {
            return this;
        }

        if (current) {
            hide($('#' + options.elementPrefix + current));
            $('#' + current).removeClass('active');
        }

        show($element);
        $toggler.addClass('active');
        current = togglerId;
        document.location.hash = current;
        $(window).scrollTop(0);
    },

    hide = function(element) {
        options.onShow(element);
        $(element).hide();
    },

    hideAll = function() {
        $elements.hide();
        $togglers.removeClass('active');
    },

    show = function(element) {
        options.onHide(element);
        $(element).show();
    };

    initialize(toggler, element, _options);

    return{
        display: display,
        hide: hide,
        hideAll: hideAll,
        show: show
    };
};
                                                                                                                                                                                                         /**
 * @copyright	(C) 2007 Open Source Matters, Inc. <https://www.joomla.org>
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

Object.append(Browser.Features, {
	localstorage: (function() {
		return ('localStorage' in window) && window.localStorage !== null;
	})()
});

/**
 * Tabs behavior
 *
 * @package		Joomla!
 * @subpackage	JavaScript
 * @since		1.5
 */
var JTabs = new Class({
	Implements: [Options, Events],

	options : {
		display: 0,
		useStorage: true,
		onActive: function(title, description) {
			description.setStyle('display', 'block');
			title.addClass('open').removeClass('closed');
		},
		onBackground: function(title, description){
			description.setStyle('display', 'none');
			title.addClass('closed').removeClass('open');
		},
		titleSelector: 'dt',
		descriptionSelector: 'dd'
	},

	initialize: function(dlist, options){
		this.setOptions(options);
		this.dlist = document.id(dlist);
		this.titles = this.dlist.getChildren(this.options.titleSelector);
		this.descriptions = this.dlist.getChildren(this.options.descriptionSelector);
		this.content = new Element('div').inject(this.dlist, 'after').addClass('current');
		this.storageName = 'jpanetabs_'+this.dlist.id;

		if (this.options.useStorage) {
			if (Browser.Features.localstorage) {
				this.options.display = this.options.display || localStorage[this.storageName];
			} else {
				this.options.display = this.options.display || Cookie.read(this.storageName);
			}
		}
		if (this.options.display === null || this.options.display === undefined) {
			this.options.display = 0;
		}
		this.options.display = this.options.display.toInt().limit(0, this.titles.length-1);

		for (var i = 0, l = this.titles.length; i < l; i++)
		{
			var title = this.titles[i];
			var description = this.descriptions[i];
			title.setStyle('cursor', 'pointer');
			title.addEvent('click', this.display.bind(this, i));
			description.inject(this.content);
		}

		this.display(this.options.display);

		if (this.options.initialize) this.options.initialize.call(this);
	},

	hideAllBut: function(but) {
		for (var i = 0, l = this.titles.length; i < l; i++)
		{
			if (i != but) this.fireEvent('onBackground', [this.titles[i], this.descriptions[i]]);
		}
	},

	display: function(i) {
		this.hideAllBut(i);
		this.fireEvent('onActive', [this.titles[i], this.descriptions[i]]);
		if (this.options.useStorage) {
			if (Browser.Features.localstorage) {
				localStorage[this.storageName] = i;
			} else {
				Cookie.write(this.storageName, i);
			}
		}
	}
});
