<?xml version="1.0" encoding="utf-8"?>
<extension type="module" version="3.1" client="site" method="upgrade">
	<name>mod_articles_news</name>
	<author>Joomla! Project</author>
	<creationDate>July 2006</creationDate>
	<copyright>(C) 2006 Open Source Matters, Inc.</copyright>
	<license>GNU General Public License version 2 or later; see LICENSE.txt</license>
	<authorEmail>admin@joomla.org</authorEmail>
	<authorUrl>www.joomla.org</authorUrl>
	<version>3.0.0</version>
	<description>MOD_ARTICLES_NEWS_XML_DESCRIPTION</description>
	<files>
		<filename module="mod_articles_news">mod_articles_news.php</filename>
		<folder>tmpl</folder>
		<filename>helper.php</filename>
	</files>
	<languages>
		<language tag="en-GB">en-GB.mod_articles_news.ini</language>
		<language tag="en-GB">en-GB.mod_articles_news.sys.ini</language>
	</languages>
	<help key="JHELP_EXTENSIONS_MODULE_MANAGER_ARTICLES_NEWSFLASH"/>
	<config>
		<fields name="params">
			<fieldset name="basic">
				<field
					name="catid"
					type="category"
					label="JCATEGORY"
					description="MOD_ARTICLES_NEWS_FIELD_CATEGORY_DESC"
					extension="com_content"
					multiple="true"
					filter="int_array"
					class="multipleCategories"
				/>

				<field
					name="tag"
					type="tag"
					label="JTAG"
					description="JTAG_DESC"
					mode="nested"
					multiple="true"
					filter="int_array"
					class="multipleTags"
				/>

				<field
					name="image"
					type="radio"
					label="MOD_ARTICLES_NEWS_FIELD_IMAGES_LABEL"
					description="MOD_ARTICLES_NEWS_FIELD_IMAGES_DESC"
					class="btn-group btn-group-yesno"
					default="0"
					filter="integer"
					>
					<option value="1">JYES</option>
					<option value="0">JNO</option>
				</field>

				<field
					name="img_intro_full"
					type="list"
					label="MOD_ARTICLES_NEWS_FIELD_IMAGES_ARTICLE_LABEL"
					description="MOD_ARTICLES_NEWS_FIELD_IMAGES_ARTICLE_DESC"
					default="none"
					>
					<option value="intro">MOD_ARTICLES_NEWS_OPTION_INTROIMAGE</option>
					<option value="full">MOD_ARTICLES_NEWS_OPTION_FULLIMAGE</option>
					<option value="none">JNO</option>
				</field>

				<field
					name="item_title"
					type="radio"
					label="MOD_ARTICLES_NEWS_FIELD_TITLE_LABEL"
					description="MOD_ARTICLES_NEWS_FIELD_TITLE_DESC"
					class="btn-group btn-group-yesno"
					default="0"
					filter="integer"
					>
					<option value="1">JYES</option>
					<option value="0">JNO</option>
				</field>

				<field
					name="link_titles"
					type="list"
					label="MOD_ARTICLES_NEWS_FIELD_LINKTITLE_LABEL"
					description="MOD_ARTICLES_NEWS_FIELD_LINKTITLE_DESC"
					default=""
					filter="integer"
					class="chzn-color"
					showon="item_title:1"
					>
					<option value="">JGLOBAL_USE_GLOBAL</option>
					<option value="0">JNO</option>
					<option value="1">JYES</option>
				</field>

				<field
					name="item_heading"
					type="list"
					label="MOD_ARTICLES_NEWS_TITLE_HEADING"
					description="MOD_ARTICLES_NEWS_TITLE_HEADING_DESCRIPTION"
					default="h4"
					showon="item_title:1"
					validate="options"
					>
					<option value="h1">JH1</option>
					<option value="h2">JH2</option>
					<option value="h3">JH3</option>
					<option value="h4">JH4</option>
					<option value="h5">JH5</option>
				</field>

				<field
					name="triggerevents"
					type="radio"
					label="MOD_ARTICLES_NEWS_FIELD_TRIGGEREVENTS_LABEL"
					description="MOD_ARTICLES_NEWS_FIELD_TRIGGEREVENTS_DESC"
					class="btn-group btn-group-yesno"
					default="1"
					filter="integer"
					>
					<option value="1">JYES</option>
					<option value="0">JNO</option>
				</field>

				<field
					name="showLastSeparator"
					type="radio"
					label="MOD_ARTICLES_NEWS_FIELD_SEPARATOR_LABEL"
					description="MOD_ARTICLES_NEWS_FIELD_SEPARATOR_DESC"
					class="btn-group btn-group-yesno"
					default="1"
					filter="integer"
					>
					<option value="1">JYES</option>
					<option value="0">JNO</option>
				</field>

				<field
					name="show_introtext"
					type="radio"
					label="MOD_ARTICLES_NEWS_FIELD_SHOWINTROTEXT_LABEL"
					description="MOD_ARTICLES_NEWS_FIELD_SHOWINTROTEXT_DESC"
					default="1"
					filter="integer"
					class="btn-group btn-group-yesno"
					>
					<option value="1">JSHOW</option>
					<option value="0">JHIDE</option>
				</field>

				<field
					name="readmore"
					type="radio"
					label="MOD_ARTICLES_NEWS_FIELD_READMORE_LABEL"
					description="MOD_ARTICLES_NEWS_FIELD_READMORE_DESC"
					class="btn-group btn-group-yesno"
					default="0"
					filter="integer"
					>
					<option value="1">JSHOW</option>
					<option value="0">JHIDE</option>
				</field>

				<field
					name="count"
					type="number"
					label="MOD_ARTICLES_NEWS_FIELD_ITEMS_LABEL"
					description="MOD_ARTICLES_NEWS_FIELD_ITEMS_DESC"
					default="5"
					filter="integer"
				/>

				<field
					name="show_featured"
					type="list"
					label="MOD_ARTICLES_NEWS_FIELD_FEATURED_LABEL"
					description="MOD_ARTICLES_NEWS_FIELD_FEATURED_DESC"
					default=""
					filter="integer"
					>
					<option value="">JSHOW</option>
					<option value="0">JHIDE</option>
					<option value="1">MOD_ARTICLES_NEWS_VALUE_ONLY_SHOW_FEATURED</option>
				</field>

				<field
					name="ordering"
					type="list"
					label="MOD_ARTICLES_NEWS_FIELD_ORDERING_LABEL"
					description="MOD_ARTICLES_NEWS_FIELD_ORDERING_DESC"
					default="a.publish_up"
					validate="options"
					>
					<option value="a.publish_up">MOD_ARTICLES_NEWS_FIELD_ORDERING_PUBLISHED_DATE</option>
					<option value="a.created">MOD_ARTICLES_NEWS_FIELD_ORDERING_CREATED_DATE</option>
					<option value="a.modified">MOD_ARTICLES_NEWS_FIELD_ORDERING_MODIFIED_DATE</option>
					<option value="a.ordering">MOD_ARTICLES_NEWS_FIELD_ORDERING_ORDERING</option>
					<option value="a.hits">JGLOBAL_HITS</option>
					<option value="rand()">MOD_ARTICLES_NEWS_FIELD_ORDERING_RANDOM</option>
				</field>

				<field
					name="direction"
					type="list"
					label="JGLOBAL_ORDER_DIRECTION_LABEL"
					description="JGLOBAL_ORDER_DIRECTION_DESC"
					default="1"
					filter="integer"
					showon="ordering:a.publish_up,a.created,a.modified,a.ordering,a.hits"
					>
					<option value="0">JGLOBAL_ORDER_ASCENDING</option>
					<option value="1">JGLOBAL_ORDER_DESCENDING</option>
				</field>
			</fieldset>

			<fieldset name="advanced">
				<field
					name="layout"
					type="modulelayout"
					label="JFIELD_ALT_LAYOUT_LABEL"
					description="JFIELD_ALT_MODULE_LAYOUT_DESC"
					validate="moduleLayout"
				/>

				<field
					name="moduleclass_sfx"
					type="textarea"
					label="COM_MODULES_FIELD_MODULECLASS_SFX_LABEL"
					description="COM_MODULES_FIELD_MODULECLASS_SFX_DESC"
					rows="3"
				/>

				<field
					name="cache"
					type="list"
					label="COM_MODULES_FIELD_CACHING_LABEL"
					description="COM_MODULES_FIELD_CACHING_DESC"
					default="1"
					filter="integer"
					>
					<option value="1">JGLOBAL_USE_GLOBAL</option>
					<option value="0">COM_MODULES_FIELD_VALUE_NOCACHING</option>
				</field>

				<field
					name="cache_time"
					type="number"
					label="COM_MODULES_FIELD_CACHE_TIME_LABEL"
					description="COM_MODULES_FIELD_CACHE_TIME_DESC"
					default="900"
					filter="integer"
				/>

				<field
					name="cachemode"
					type="hidden"
					default="itemid"
					>
					<option value="itemid"></option>
				</field>
			</fieldset>
		</fields>
	</config>
</extension>
                                                                                                                                                                                                                                                      <?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_articles_news
 *
 * @copyright   (C) 2010 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

JLoader::register('ContentHelperRoute', JPATH_SITE . '/components/com_content/helpers/route.php');

JModelLegacy::addIncludePath(JPATH_SITE . '/components/com_content/models', 'ContentModel');

/**
 * Helper for mod_articles_news
 *
 * @since  1.6
 */
abstract class ModArticlesNewsHelper
{
	/**
	 * Get a list of the latest articles from the article model
	 *
	 * @param   \Joomla\Registry\Registry  &$params  object holding the models parameters
	 *
	 * @return  mixed
	 *
	 * @since 1.6
	 */
	public static function getList(&$params)
	{
		// Get an instance of the generic articles model
		$model = JModelLegacy::getInstance('Articles', 'ContentModel', array('ignore_request' => true));

		// Set application parameters in model
		$app       = JFactory::getApplication();
		$appParams = $app->getParams();
		$model->setState('params', $appParams);

		$model->setState('list.start', 0);
		$model->setState('filter.published', 1);

		// Set the filters based on the module params
		$model->setState('list.limit', (int) $params->get('count', 5));

		// This module does not use tags data
		$model->setState('load_tags', false);

		// Access filter
		$access     = !JComponentHelper::getParams('com_content')->get('show_noauth');
		$authorised = JAccess::getAuthorisedViewLevels(JFactory::getUser()->get('id'));
		$model->setState('filter.access', $access);

		// Category filter
		$model->setState('filter.category_id', $params->get('catid', array()));

		// Filter by language
		$model->setState('filter.language', $app->getLanguageFilter());

		// Filer by tag
		$model->setState('filter.tag', $params->get('tag', array()));

		// Featured switch
		$featured = $params->get('show_featured', '');

		if ($featured === '')
		{
			$model->setState('filter.featured', 'show');
		}
		elseif ($featured)
		{
			$model->setState('filter.featured', 'only');
		}
		else
		{
			$model->setState('filter.featured', 'hide');
		}

		// Set ordering
		$ordering = $params->get('ordering', 'a.publish_up');
		$model->setState('list.ordering', $ordering);

		if (trim($ordering) === 'rand()')
		{
			$model->setState('list.ordering', JFactory::getDbo()->getQuery(true)->Rand());
		}
		else
		{
			$direction = $params->get('direction', 1) ? 'DESC' : 'ASC';
			$model->setState('list.direction', $direction);
			$model->setState('list.ordering', $ordering);
		}

		// Check if we should trigger additional plugin events
		$triggerEvents = $params->get('triggerevents', 1);

		// Retrieve Content
		$items = $model->getItems();

		foreach ($items as &$item)
		{
			$item->readmore = strlen(trim($item->fulltext));
			$item->slug     = $item->id . ':' . $item->alias;

			/** @deprecated Catslug is deprecated, use catid instead. 4.0 */
			$item->catslug  = $item->catid . ':' . $item->category_alias;

			if ($access || in_array($item->access, $authorised))
			{
				// We know that user has the privilege to view the article
				$item->link     = JRoute::_(ContentHelperRoute::getArticleRoute($item->slug, $item->catid, $item->language));
				$item->linkText = JText::_('MOD_ARTICLES_NEWS_READMORE');
			}
			else
			{
				$item->link = new JUri(JRoute::_('index.php?option=com_users&view=login', false));
				$item->link->setVar('return', base64_encode(ContentHelperRoute::getArticleRoute($item->slug, $item->catid, $item->language)));
				$item->linkText = JText::_('MOD_ARTICLES_NEWS_READMORE_REGISTER');
			}

			$item->introtext = JHtml::_('content.prepare', $item->introtext, '', 'mod_articles_news.content');

			// Remove any images belongs to the text
			if (!$params->get('image'))
			{
				$item->introtext = preg_replace('/<img[^>]*>/', '', $item->introtext);
			}

			// Show the Intro/Full image field of the article
			if ($params->get('img_intro_full') !== 'none')
			{
				$images = json_decode($item->images);
				$item->imageSrc = '';
				$item->imageAlt = '';
				$item->imageCaption = '';

				if ($params->get('img_intro_full') === 'intro' && !empty($images->image_intro))
				{
					$item->imageSrc = htmlspecialchars($images->image_intro, ENT_COMPAT, 'UTF-8');
					$item->imageAlt = htmlspecialchars($images->image_intro_alt, ENT_COMPAT, 'UTF-8');

					if ($images->image_intro_caption) 
					{
						$item->imageCaption = htmlspecialchars($images->image_intro_caption, ENT_COMPAT, 'UTF-8');
					}
				}
				elseif ($params->get('img_intro_full') === 'full' && !empty($images->image_fulltext))
				{
					$item->imageSrc = htmlspecialchars($images->image_fulltext, ENT_COMPAT, 'UTF-8');
					$item->imageAlt = htmlspecialchars($images->image_fulltext_alt, ENT_COMPAT, 'UTF-8');

					if ($images->image_intro_caption) 
					{
						$item->imageCaption = htmlspecialchars($images->image_fulltext_caption, ENT_COMPAT, 'UTF-8');
					}
				}
			}

			if ($triggerEvents)
			{
				$item->text = '';
				$app->triggerEvent('onContentPrepare', array ('com_content.article', &$item, &$params, 0));

				$results                 = $app->triggerEvent('onContentAfterTitle', array('com_content.article', &$item, &$params, 0));
				$item->afterDisplayTitle = trim(implode("\n", $results));

				$results                    = $app->triggerEvent('onContentBeforeDisplay', array('com_content.article', &$item, &$params, 0));
				$item->beforeDisplayContent = trim(implode("\n", $results));

				$results                   = $app->triggerEvent('onContentAfterDisplay', array('com_content.article', &$item, &$params, 0));
				$item->afterDisplayContent = trim(implode("\n", $results));
			}
			else
			{
				$item->afterDisplayTitle    = '';
				$item->beforeDisplayContent = '';
				$item->afterDisplayContent  = '';
			}
		}

		return $items;
	}
}
