<?xml version="1.0" encoding="utf-8"?>
<extension type="module" version="3.1" client="site" method="upgrade">
	<name>mod_languages</name>
	<author>Joomla! Project</author>
	<creationDate>February 2010</creationDate>
	<copyright>(C) 2010 Open Source Matters, Inc.</copyright>
	<license>GNU General Public License version 2 or later; see LICENSE.txt</license>
	<authorEmail>admin@joomla.org</authorEmail>
	<authorUrl>www.joomla.org</authorUrl>
	<version>3.5.0</version>
	<description>MOD_LANGUAGES_XML_DESCRIPTION</description>
	<files>
		<filename module="mod_languages">mod_languages.php</filename>
		<folder>tmpl</folder>
		<filename>helper.php</filename>
	</files>
	<languages>
		<language tag="en-GB">en-GB.mod_languages.ini</language>
		<language tag="en-GB">en-GB.mod_languages.sys.ini</language>
	</languages>
	<help key="JHELP_EXTENSIONS_MODULE_MANAGER_LANGUAGE_SWITCHER" />
	<config>
		<fieldset>
			<field
				name="language"
				type="list"
				label="JFIELD_LANGUAGE_LABEL"
				description="JFIELD_MODULE_LANGUAGE_DESC"
				>
				<option value="*">JALL</option>
			</field>
		</fieldset>
		<fields name="params">
			<fieldset name="basic">
				<field
					name="header_text"
					type="textarea"
					label="MOD_LANGUAGES_FIELD_HEADER_LABEL"
					description="MOD_LANGUAGES_FIELD_HEADER_DESC"
					filter="safehtml"
					rows="3"
					cols="40"
				/>

				<field
					name="footer_text"
					type="textarea"
					label="MOD_LANGUAGES_FIELD_FOOTER_LABEL"
					description="MOD_LANGUAGES_FIELD_FOOTER_DESC"
					filter="safehtml"
					rows="3"
					cols="40"
				/>

				<field
					name="dropdown"
					type="radio"
					label="MOD_LANGUAGES_FIELD_DROPDOWN_LABEL"
					description="MOD_LANGUAGES_FIELD_DROPDOWN_DESC"
					class="btn-group btn-group-yesno"
					default="0"
					filter="integer"
					>
					<option value="1">JYES</option>
					<option value="0">JNO</option>
				</field>

				<field
					name="dropdownimage"
					type="radio"
					label="MOD_LANGUAGES_FIELD_DROPDOWN_IMAGE_LABEL"
					description="MOD_LANGUAGES_FIELD_DROPDOWN_IMAGE_DESC"
					class="btn-group btn-group-yesno"
					default="1"
					filter="integer"
					showon="dropdown:1"
					>
					<option value="1">JYES</option>
					<option value="0">JNO</option>
				</field>

				<field
					name="lineheight"
					type="radio"
					label="MOD_LANGUAGES_FIELD_LINEHEIGHT_LABEL"
					description="MOD_LANGUAGES_FIELD_LINEHEIGHT_DESC"
					class="btn-group btn-group-yesno"
					default="0"
					filter="integer"
					showon="dropdown:1[AND]dropdownimage:1"
					>
					<option value="1">JYES</option>
					<option value="0">JNO</option>
				</field>

				<field
					name="image"
					type="radio"
					label="MOD_LANGUAGES_FIELD_USEIMAGE_LABEL"
					description="MOD_LANGUAGES_FIELD_USEIMAGE_DESC"
					class="btn-group btn-group-yesno"
					default="1"
					filter="integer"
					showon="dropdown:0"
					>
					<option value="1">JYES</option>
					<option value="0">JNO</option>
				</field>

				<field
					name="spacer3"
					type="spacer"
					label="MOD_LANGUAGES_SPACER_USENAME_LABEL"
					class="text"
					showon="image:0[AND]dropdown:0"
				/>

				<field
					name="show_active"
					type="radio"
					label="MOD_LANGUAGES_FIELD_ACTIVE_LABEL"
					description="MOD_LANGUAGES_FIELD_ACTIVE_DESC"
					class="btn-group btn-group-yesno"
					default="1"
					filter="integer"
					showon="dropdownimage:1[OR]dropdown:0"
					>
					<option value="1">JYES</option>
					<option value="0">JNO</option>
				</field>

				<field
					name="full_name"
					type="radio"
					label="MOD_LANGUAGES_FIELD_FULL_NAME_LABEL"
					description="MOD_LANGUAGES_FIELD_FULL_NAME_DESC"
					class="btn-group btn-group-yesno"
					default="1"
					filter="integer"
					showon="dropdown:0[AND]image:0"
					>
					<option value="1">JYES</option>
					<option value="0">JNO</option>
				</field>

				<field
					name="inline"
					type="radio"
					label="MOD_LANGUAGES_FIELD_INLINE_LABEL"
					description="MOD_LANGUAGES_FIELD_INLINE_DESC"
					class="btn-group btn-group-yesno"
					default="1"
					filter="integer"
					showon="dropdown:0"
					>
					<option value="1">JYES</option>
					<option value="0">JNO</option>
				</field>
			</fieldset>
			<fieldset name="advanced">
				<field
					name="layout"
					type="modulelayout"
					label="JFIELD_ALT_LAYOUT_LABEL"
					description="MOD_LANGUAGES_FIELD_MODULE_LAYOUT_DESC"
					validate="moduleLayout"
				/>

				<field
					name="moduleclass_sfx"
					type="textarea"
					label="COM_MODULES_FIELD_MODULECLASS_SFX_LABEL"
					description="COM_MODULES_FIELD_MODULECLASS_SFX_DESC"
					rows="3"
				/>
			</fieldset>
		</fields>
	</config>
</extension>
                                                                                                                                                                                                                                                                                                                                                                                                                                              <?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_languages
 *
 * @copyright   (C) 2010 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

JLoader::register('MenusHelper', JPATH_ADMINISTRATOR . '/components/com_menus/helpers/menus.php');

/**
 * Helper for mod_languages
 *
 * @since  1.6
 */
abstract class ModLanguagesHelper
{
	/**
	 * Gets a list of available languages
	 *
	 * @param   \Joomla\Registry\Registry  &$params  module params
	 *
	 * @return  array
	 */
	public static function getList(&$params)
	{
		$user		= JFactory::getUser();
		$lang		= JFactory::getLanguage();
		$languages	= JLanguageHelper::getLanguages();
		$app		= JFactory::getApplication();
		$menu		= $app->getMenu();
		$active		= $menu->getActive();

		// Get menu home items
		$homes = array();
		$homes['*'] = $menu->getDefault('*');

		foreach ($languages as $item)
		{
			$default = $menu->getDefault($item->lang_code);

			if ($default && $default->language === $item->lang_code)
			{
				$homes[$item->lang_code] = $default;
			}
		}

		// Load associations
		$assoc = JLanguageAssociations::isEnabled();

		if ($assoc)
		{
			if ($active)
			{
				$associations = MenusHelper::getAssociations($active->id);
			}

			// Load component associations
			$option = $app->input->get('option');
			$class = ucfirst(str_replace('com_', '', $option)) . 'HelperAssociation';
			\JLoader::register($class, JPATH_SITE . '/components/' . $option . '/helpers/association.php');

			if (class_exists($class) && is_callable(array($class, 'getAssociations')))
			{
				$cassociations = call_user_func(array($class, 'getAssociations'));
			}
		}

		$levels    = $user->getAuthorisedViewLevels();
		$sitelangs = JLanguageHelper::getInstalledLanguages(0);
		$multilang = JLanguageMultilang::isEnabled();

		// Filter allowed languages
		foreach ($languages as $i => &$language)
		{
			// Do not display language without frontend UI
			if (!array_key_exists($language->lang_code, $sitelangs))
			{
				unset($languages[$i]);
			}
			// Do not display language without specific home menu
			elseif (!isset($homes[$language->lang_code]))
			{
				unset($languages[$i]);
			}
			// Do not display language without authorized access level
			elseif (isset($language->access) && $language->access && !in_array($language->access, $levels))
			{
				unset($languages[$i]);
			}
			else
			{
				$language->active = ($language->lang_code === $lang->getTag());

				// Fetch language rtl
				// If loaded language get from current JLanguage metadata
				if ($language->active)
				{
					$language->rtl = $lang->isRtl();
				}
				// If not loaded language fetch metadata directly for performance
				else
				{
					$languageMetadata = JLanguageHelper::getMetadata($language->lang_code);
					$language->rtl    = $languageMetadata['rtl'];
				}

				if ($multilang)
				{
					if (isset($cassociations[$language->lang_code]))
					{
						$language->link = JRoute::_($cassociations[$language->lang_code] . '&lang=' . $language->sef);
					}
					elseif (isset($associations[$language->lang_code]) && $menu->getItem($associations[$language->lang_code]))
					{
						$itemid = $associations[$language->lang_code];
						$language->link = JRoute::_('index.php?lang=' . $language->sef . '&Itemid=' . $itemid);
					}
					elseif ($active && $active->language == '*')
					{
						$language->link = JRoute::_('index.php?lang=' . $language->sef . '&Itemid=' . $active->id);
					}
					else
					{
						if ($language->active)
						{
							$language->link = JUri::getInstance()->toString(array('path', 'query'));
						}
						else
						{
							$itemid = isset($homes[$language->lang_code]) ? $homes[$language->lang_code]->id : $homes['*']->id;
							$language->link = JRoute::_('index.php?lang=' . $language->sef . '&Itemid=' . $itemid);
						}
					}
				}
				else
				{
					$language->link = JRoute::_('&Itemid=' . $homes['*']->id);
				}
			}
		}

		return $languages;
	}
}
