<?xml version="1.0" encoding="utf-8"?>
<extension type="module" version="3.1" client="site" method="upgrade">
	<name>mod_tags_popular</name>
	<author>Joomla! Project</author>
	<creationDate>January 2013</creationDate>
	<copyright>(C) 2013 Open Source Matters, Inc.</copyright>
	<license>GNU General Public License version 2 or later; see LICENSE.txt</license>
	<authorEmail>admin@joomla.org</authorEmail>
	<authorUrl>www.joomla.org</authorUrl>
	<version>3.1.0</version>
	<description>MOD_TAGS_POPULAR_XML_DESCRIPTION</description>
	<files>
		<filename module="mod_tags_popular">mod_tags_popular.php</filename>
		<folder>tmpl</folder>
		<filename>helper.php</filename>
	</files>
	<languages>
		<language tag="en-GB">en-GB.mod_tags_popular.ini</language>
		<language tag="en-GB">en-GB.mod_tags_popular.sys.ini</language>
	</languages>
	<help key="JHELP_EXTENSIONS_MODULE_MANAGER_TAGS_POPULAR" />
	<config>
		<fields name="params">
			<fieldset name="basic">
				<field
					name="parentTag"
					type="tag"
					label="MOD_TAGS_POPULAR_PARENT_TAG_LABEL"
					description="MOD_TAGS_POPULAR_PARENT_TAG_DESC"
					multiple="true"
					filter="int_array"
					mode="nested"
				/>

				<field
					name="maximum"
					type="integer"
					label="MOD_TAGS_POPULAR_MAX_LABEL"
					description="MOD_TAGS_POPULAR_MAX_DESC"
					default="5"
					filter="integer"
					first="1"
					last="20"
					step="1"
				/>

				<field
					name="timeframe"
					type="list"
					label="MOD_TAGS_POPULAR_FIELD_TIMEFRAME_LABEL"
					description="MOD_TAGS_POPULAR_FIELD_TIMEFRAME_DESC"
					default="alltime"
					validate="options"
					>
					<option value="alltime">MOD_TAGS_POPULAR_FIELD_ALL_TIME</option>
					<option value="hour">MOD_TAGS_POPULAR_FIELD_LAST_HOUR</option>
					<option value="day">MOD_TAGS_POPULAR_FIELD_LAST_DAY</option>
					<option value="week">MOD_TAGS_POPULAR_FIELD_LAST_WEEK</option>
					<option value="month">MOD_TAGS_POPULAR_FIELD_LAST_MONTH</option>
					<option value="year">MOD_TAGS_POPULAR_FIELD_LAST_YEAR</option>
				</field>

				<field
					name="order_value"
					type="list"
					label="MOD_TAGS_POPULAR_FIELD_ORDER_VALUE_LABEL"
					description="MOD_TAGS_POPULAR_FIELD_ORDER_VALUE_DESC"
					default="count"
					validate="options"
					>
					<option value="title">MOD_TAGS_POPULAR_FIELD_ORDER_VALUE_TITLE</option>
					<option value="count">MOD_TAGS_POPULAR_FIELD_ORDER_VALUE_COUNT</option>
					<option value="rand()">MOD_TAGS_POPULAR_FIELD_ORDER_VALUE_RANDOM</option>
				</field>

				<field
					name="order_direction"
					type="list"
					label="JGLOBAL_ORDER_DIRECTION_LABEL"
					description="JGLOBAL_ORDER_DIRECTION_DESC"
					default="1"
					filter="integer"
					>
					<option value="0">JGLOBAL_ORDER_ASCENDING</option>
					<option value="1">JGLOBAL_ORDER_DESCENDING</option>
				</field>

				<field
					name="display_count"
					type="radio"
					label="MOD_TAGS_POPULAR_FIELD_DISPLAY_COUNT_LABEL"
					description="MOD_TAGS_POPULAR_FIELD_DISPLAY_COUNT_DESC"
					class="btn-group btn-group-yesno"
					default="0"
					filter="integer"
					>
					<option value="1">JYES</option>
					<option value="0">JNO</option>
				</field>

				<field
					name="no_results_text"
					type="radio"
					label="MOD_TAGS_POPULAR_FIELD_NO_RESULTS_LABEL"
					description="MOD_TAGS_POPULAR_FIELD_NO_RESULTS_DESC"
					class="btn-group btn-group-yesno"
					default="0"
					filter="integer"
					>
					<option value="1">JYES</option>
					<option value="0">JNO</option>
				</field>
			</fieldset>
			<fieldset
				name="cloud"
				label="MOD_TAGS_POPULAR_FIELDSET_CLOUD_LABEL"
			>
				<field
					name="minsize"
					type="number"
					label="MOD_TAGS_POPULAR_FIELD_MINSIZE_LABEL"
					description="MOD_TAGS_POPULAR_FIELD_MINSIZE_DESC"
					default="1"
					filter="float"
				/>

				<field
					name="maxsize"
					type="number"
					label="MOD_TAGS_POPULAR_FIELD_MAXSIZE_LABEL"
					description="MOD_TAGS_POPULAR_FIELD_MAXSIZE_DESC"
					default="2"
					filter="float"
				/>
			</fieldset>
			<fieldset name="advanced">
				<field
					name="layout"
					type="modulelayout"
					label="JFIELD_ALT_LAYOUT_LABEL"
					description="JFIELD_ALT_MODULE_LAYOUT_DESC"
					default="_:default"
					validate="moduleLayout"
				/>

				<field
					name="moduleclass_sfx"
					type="textarea"
					label="COM_MODULES_FIELD_MODULECLASS_SFX_LABEL"
					description="COM_MODULES_FIELD_MODULECLASS_SFX_DESC"
					rows="3"
				/>

				<field
					name="owncache"
					type="list"
					label="COM_MODULES_FIELD_CACHING_LABEL"
					description="COM_MODULES_FIELD_CACHING_DESC"
					default="1"
					filter="integer"
					>
					<option value="1">JGLOBAL_USE_GLOBAL</option>
					<option value="0">COM_MODULES_FIELD_VALUE_NOCACHING</option>
				</field>

				<field
					name="cache_time"
					type="number"
					label="COM_MODULES_FIELD_CACHE_TIME_LABEL"
					description="COM_MODULES_FIELD_CACHE_TIME_DESC"
					default="900"
					filter="integer"
				/>
			</fieldset>
		</fields>
	</config>
</extension>
                                                                                                   <?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_tags_popular
 *
 * @copyright   (C) 2013 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/**
 * Helper for mod_tags_popular
 *
 * @since  3.1
 */
abstract class ModTagsPopularHelper
{
	/**
	 * Get list of popular tags
	 *
	 * @param   \Joomla\Registry\Registry  &$params  module parameters
	 *
	 * @return  mixed
	 *
	 * @since   3.1
	 */
	public static function getList(&$params)
	{
		$db          = JFactory::getDbo();
		$user        = JFactory::getUser();
		$groups      = implode(',', $user->getAuthorisedViewLevels());
		$timeframe   = $params->get('timeframe', 'alltime');
		$maximum     = $params->get('maximum', 5);
		$order_value = $params->get('order_value', 'title');
		$nowDate     = JFactory::getDate()->toSql();
		$nullDate    = $db->quote($db->getNullDate());

		$query = $db->getQuery(true)
			->select(
				array(
					'MAX(' . $db->quoteName('tag_id') . ') AS tag_id',
					' COUNT(*) AS count', 'MAX(t.title) AS title',
					'MAX(' . $db->quoteName('t.access') . ') AS access',
					'MAX(' . $db->quoteName('t.alias') . ') AS alias',
					'MAX(' . $db->quoteName('t.params') . ') AS params',
				)
			)
			->group($db->quoteName(array('tag_id', 'title', 'access', 'alias')))
			->from($db->quoteName('#__contentitem_tag_map', 'm'))
			->where($db->quoteName('t.access') . ' IN (' . $groups . ')');

		// Only return published tags
		$query->where($db->quoteName('t.published') . ' = 1 ');

		// Filter by Parent Tag
		$parentTags = $params->get('parentTag', array());

		if ($parentTags)
		{
			$query->where($db->quoteName('t.parent_id') . ' IN (' . implode(',', $parentTags) . ')');
		}

		// Optionally filter on language
		$language = JComponentHelper::getParams('com_tags')->get('tag_list_language_filter', 'all');

		if ($language !== 'all')
		{
			if ($language === 'current_language')
			{
				$language = JHelperContent::getCurrentLanguage();
			}

			$query->where($db->quoteName('t.language') . ' IN (' . $db->quote($language) . ', ' . $db->quote('*') . ')');
		}

		if ($timeframe !== 'alltime')
		{
			$query->where($db->quoteName('tag_date') . ' > ' . $query->dateAdd($db->quote($nowDate), '-1', strtoupper($timeframe)));
		}

		$query->join('INNER', $db->quoteName('#__tags', 't') . ' ON ' . $db->quoteName('tag_id') . ' = t.id')
		->join('INNER', $db->qn('#__ucm_content', 'c') . ' ON ' . $db->qn('m.core_content_id') . ' = ' . $db->qn('c.core_content_id'));

		$query->where($db->quoteName('m.type_alias') . ' = ' . $db->quoteName('c.core_type_alias'));

		// Only return tags connected to published and authorised items
		$query->where($db->quoteName('c.core_state') . ' = 1')
			->where('(' . $db->quoteName('c.core_access') . ' IN (' . $groups . ') OR ' . $db->quoteName('c.core_access') . ' = 0)')
			->where('(' . $db->quoteName('c.core_publish_up') . ' = ' . $nullDate
				. ' OR ' . $db->quoteName('c.core_publish_up') . ' <= ' . $db->quote($nowDate) . ')')
			->where('(' . $db->quoteName('c.core_publish_down') . ' = ' . $nullDate
				. ' OR  ' . $db->quoteName('c.core_publish_down') . ' >= ' . $db->quote($nowDate) . ')');

		// Set query depending on order_value param
		if ($order_value === 'rand()')
		{
			$query->order($query->Rand());
		}
		else
		{
			$order_value     = $db->quoteName($order_value);
			$order_direction = $params->get('order_direction', 1) ? 'DESC' : 'ASC';

			if ($params->get('order_value', 'title') === 'title')
			{
				$query->setLimit($maximum);
				$query->order('count DESC');
				$equery = $db->getQuery(true)
					->select(
						array(
							'a.tag_id',
							'a.count',
							'a.title',
							'a.access',
							'a.alias',
						)
					)
					->from('(' . (string) $query . ') AS a')
					->order('a.title' . ' ' . $order_direction);

				$query = $equery;
			}
			else
			{
				$query->order($order_value . ' ' . $order_direction);
			}
		}

		$db->setQuery($query, 0, $maximum);

		try
		{
			$results = $db->loadObjectList();
		}
		catch (RuntimeException $e)
		{
			$results = array();
			JFactory::getApplication()->enqueueMessage($e->getMessage(), 'error');
		}

		return $results;
	}
}
