<?php
/**
 * Obtiene todos los gastos de la base de datos
 */

/**
 * Constantes para construcción de respuesta
 */
const ESTADO = "estado";
const DATOS = "clientesproveedores";
const MENSAJE = "mensaje";

const CODIGO_EXITO = 1;
const CODIGO_FALLO = 2;

require 'clientesproveedores.php';


if ($_SERVER['REQUEST_METHOD'] == 'GET') {

    // Obtener clientesproveedores de la base de datos
    $clientesproveedores = ClientesProveedores::getAll();

    // Definir tipo de la respuesta
    //header('Content-Type: application/json');

    if ($clientesproveedores) {
        //$datos[ESTADO] = CODIGO_EXITO;
        $datos[DATOS] = $clientesproveedores;
        print json_encode($datos);
    } else {
        print json_encode(array(
            ESTADO => CODIGO_FALLO,
            MENSAJE => "Ha ocurrido un error"
        ));
    }
}                                                                                                                                                       <?php

/**
 * Representa el data de los gastos
 * almacenados en la base de datos
 */
require 'DatabaseConnection.php';

class Rutas
{
    // Nombre de la tabla asociada a esta clase
    const TABLE_NAME = "rutas";

    const MONTO = "monto";

    const ETIQUETA = "etiqueta";

    const FECHA = "fecha";

    const DESCRIPCION = "descripcion";

    function __construct()
    {
    }

    /**
     * Obtiene todos los gastos de la base de datos
     * @return array|bool Arreglo con todos los gastos o false en caso de error
     */
    public static function getAll()
    {
        $consulta = "SELECT * FROM " . self::TABLE_NAME;
        try {
            // Preparar sentencia
            $comando = DatabaseConnection::getInstance()->getDb()->prepare($consulta);
            // Ejecutar sentencia preparada
            $comando->execute();

            return $comando->fetchAll(PDO::FETCH_ASSOC);

        } catch (PDOException $e) {
            return false;
        }
    }
/**
    public static function insertRow($object)
    {
        try {

            $pdo = DatabaseConnection::getInstance()->getDb();

            // Sentencia INSERT
            $comando = "INSERT INTO " . self::TABLE_NAME . " ( " .
                self::MONTO . "," .
                self::ETIQUETA . "," .
                self::FECHA . "," .
                self::DESCRIPCION . ")" .
                " VALUES(?,?,?,?)";

            // Preparar la sentencia
            $sentencia = $pdo->prepare($comando);

            $sentencia->bindParam(1, $monto);
            $sentencia->bindParam(2, $etiqueta);
            $sentencia->bindParam(3, $fecha);
            $sentencia->bindParam(4, $descripcion);

            $monto = $object[self::MONTO];
            $etiqueta = $object[self::ETIQUETA];
            $fecha = $object[self::FECHA];
            $descripcion = $object[self::DESCRIPCION];

            $sentencia->execute();

            // Retornar en el último id insertado
            return $pdo->lastInsertId();
        } catch (PDOException $e) {
            return false;
        }

    }
    */
}

?>