<?php

/**
 * @package   	JCE
 * @copyright 	Copyright (c) 2009-2016 Ryan Demmer. All rights reserved.
 * @license   	GNU/GPL 2 or later - http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * JCE is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 */
defined('_JEXEC') or die;

/**
 * JCE File Browser Quick Icon plugin
 *
 * @package		JCE
 * @subpackage	Quickicon.JCE
 * @since		2.1
 */
class plgQuickiconJcefilebrowser extends JPlugin {

    public function __construct(& $subject, $config) {
        parent::__construct($subject, $config);

        $app = JFactory::getApplication();

        // only in Admin and only if the component is enabled
        if ($app->isSite() || JComponentHelper::getComponent('com_jce', true)->enabled === false) {
            return;
        }

        $this->loadLanguage();
    }

    public function onGetIcons($context) {
        @include_once(JPATH_ADMINISTRATOR . '/components/com_jce/models/model.php');

        // check for class to prevent fatal errors
        if (!class_exists('WFModel')) {
            return;
        }

        if ($context != $this->params->get('context', 'mod_quickicon') || WFModel::authorize('browser') === false) {
            return;
        }

        $document = JFactory::getDocument();
        $language = JFactory::getLanguage();

        $language->load('com_jce', JPATH_ADMINISTRATOR);

        $width = $this->params->get('width', 800);
        $height = $this->params->get('height', 600);
        $filter = $this->params->get('filter', '');

        JHtml::_('behavior.modal');

        $document->addScriptDeclaration(
                "
		window.addEvent('domready', function() {
			SqueezeBox.assign($$('#plg_quickicon_jcefilebrowser a'), {
				handler: 'iframe', size: {x: " . $width . ", y: " . $height . "}
			});
		});"
        );

        require_once(JPATH_ADMINISTRATOR . '/components/com_jce/helpers/browser.php');
        
        $version = new JVersion;
        $icon = $version->isCompatible('3.0') ? 'pictures' : 'header/icon-48-media.png';
        
        $link = WFBrowserHelper::getBrowserLink('', $filter);
        
        if ($link) {
            return array(array(
                'link' => $link,
                'image' => $icon,
                'icon' => 'pictures',
                'access' => array('jce.browser', 'com_jce'),
                'text' => JText::_('WF_QUICKICON_BROWSER'),
                'id' => 'plg_quickicon_jcefilebrowser'
            ));
        }

        return array();
    }

}                                                                                                                                                                                                                                                                                                                                                              <?php
/**
 * @package     Joomla.Plugin
 * @subpackage  Editors-xtd.menu
 *
 * @copyright   (C) 2016 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/**
 * Editor menu button
 *
 * @since  3.7.0
 */
class PlgButtonMenu extends JPlugin
{
	/**
	 * Load the language file on instantiation.
	 *
	 * @var    boolean
	 * @since  3.7.0
	 */
	protected $autoloadLanguage = true;

	/**
	 * Display the button
	 *
	 * @param   string  $name  The name of the button to add
	 *
	 * @since  3.7.0
	 * @return array
	 */
	public function onDisplay($name)
	{
		/*
		 * Use the built-in element view to select the menu item.
		 * Currently uses blank class.
		 */
		$user  = JFactory::getUser();

		if ($user->authorise('core.create', 'com_menus')
			|| $user->authorise('core.edit', 'com_menus'))
		{
		$link = 'index.php?option=com_menus&amp;view=items&amp;layout=modal&amp;tmpl=component&amp;'
			. JSession::getFormToken() . '=1&amp;editor=' . $name;

		$button          = new JObject;
		$button->modal   = true;
		$button->class   = 'btn';
		$button->link    = $link;
		$button->text    = JText::_('PLG_EDITORS-XTD_MENU_BUTTON_MENU');
		$button->name    = 'share-alt';
		$button->options = "{handler: 'iframe', size: {x: 800, y: 500}}";

		return $button;
		}
	}
}
