<?xml version="1.0" encoding="utf-8"?>
<form>
    <field
        name="access"
        type="usergrouplist"
        label="PLG_TINY_FIELD_SETACCESS_LABEL"
        description="PLG_TINY_FIELD_SETACCESS_DESC"
        multiple="true"
        class="access-select"
        labelclass="label label-success"
    />

    <field
        name="skins"
        type="note"
        label="PLG_TINY_FIELD_SKIN_INFO_LABEL"
        description="PLG_TINY_FIELD_SKIN_INFO_DESC"
    />

    <field
        name="skin"
        type="skins"
        label="PLG_TINY_FIELD_SKIN_LABEL"
        description="PLG_TINY_FIELD_SKIN_DESC"
    />

    <field
        name="skin_admin"
        type="skins"
        label="PLG_TINY_FIELD_SKIN_ADMIN_LABEL"
        description="PLG_TINY_FIELD_SKIN_ADMIN_DESC"
    />

    <field
        name="mobile"
        type="radio"
        label="PLG_TINY_FIELD_MOBILE_LABEL"
        description="PLG_TINY_FIELD_MOBILE_DESC"
        class="btn-group btn-group-yesno"
        default="0"
        >
        <option value="1">JON</option>
        <option value="0">JOFF</option>
    </field>

    <field
        name="drag_drop"
        type="radio"
        label="PLG_TINY_FIELD_DRAG_DROP_LABEL"
        description="PLG_TINY_FIELD_DRAG_DROP_DESC"
        class="btn-group btn-group-yesno"
        default="1"
        >
        <option value="1">JON</option>
        <option value="0">JOFF</option>
    </field>

    <field
        name="path"
        type="uploaddirs"
        label="PLG_TINY_FIELD_CUSTOM_PATH_LABEL"
        description="PLG_TINY_FIELD_CUSTOM_PATH_DESC"
        class="input-xxlarge"
        showon="drag_drop:1"
    />

    <field
        name="entity_encoding"
        type="list"
        label="PLG_TINY_FIELD_ENCODING_LABEL"
        description="PLG_TINY_FIELD_ENCODING_DESC"
        default="raw"
        >
        <option value="named">PLG_TINY_FIELD_VALUE_NAMED</option>
        <option value="numeric">PLG_TINY_FIELD_VALUE_NUMERIC</option>
        <option value="raw">PLG_TINY_FIELD_VALUE_RAW</option>
    </field>

    <field
        name="lang_mode"
        type="radio"
        label="PLG_TINY_FIELD_LANGSELECT_LABEL"
        description="PLG_TINY_FIELD_LANGSELECT_DESC"
        class="btn-group btn-group-yesno"
        default="1"
        >
        <option value="1">JON</option>
        <option value="0">JOFF</option>
    </field>

    <field
        name="lang_code"
        type="filelist"
        label="PLG_TINY_FIELD_LANGCODE_LABEL"
        description="PLG_TINY_FIELD_LANGCODE_DESC"
        class="inputbox"
        stripext="1"
        directory="media/editors/tinymce/langs/"
        hide_none="1"
        default="en"
        hide_default="1"
        filter="\.js$"
        size="10"
        showon="lang_mode:0"
    />

    <field
        name="text_direction"
        type="list"
        label="PLG_TINY_FIELD_DIRECTION_LABEL"
        description="PLG_TINY_FIELD_DIRECTION_DESC"
        default="ltr"
        >
        <option value="ltr">PLG_TINY_FIELD_VALUE_LTR</option>
        <option value="rtl">PLG_TINY_FIELD_VALUE_RTL</option>
    </field>

    <field
        name="content_css"
        type="radio"
        label="PLG_TINY_FIELD_CSS_LABEL"
        description="PLG_TINY_FIELD_CSS_DESC"
        class="btn-group btn-group-yesno"
        default="1"
        >
        <option value="1">JON</option>
        <option value="0">JOFF</option>
    </field>

    <field
        name="content_css_custom"
        type="text"
        label="PLG_TINY_FIELD_CUSTOM_CSS_LABEL"
        description="PLG_TINY_FIELD_CUSTOM_CSS_DESC"
        class="input-xxlarge"
    />

    <field
        name="relative_urls"
        type="list"
        label="PLG_TINY_FIELD_URLS_LABEL"
        description="PLG_TINY_FIELD_URLS_DESC"
        default="1"
        >
        <option value="0">PLG_TINY_FIELD_VALUE_ABSOLUTE</option>
        <option value="1">PLG_TINY_FIELD_VALUE_RELATIVE</option>
    </field>

    <field
        name="newlines"
        type="list"
        label="PLG_TINY_FIELD_NEWLINES_LABEL"
        description="PLG_TINY_FIELD_NEWLINES_DESC"
        default="0"
        >
        <option value="1">PLG_TINY_FIELD_VALUE_BR</option>
        <option value="0">PLG_TINY_FIELD_VALUE_P</option>
    </field>

    <field
        name="use_config_textfilters"
        type="radio"
        label="PLG_TINY_CONFIG_TEXTFILTER_ACL_LABEL"
        description="PLG_TINY_CONFIG_TEXTFILTER_ACL_DESC"
        class="btn-group btn-group-yesno"
        default="0"
        >
        <option value="1">JON</option>
        <option value="0">JOFF</option>
    </field>

    <field
        name="invalid_elements"
        type="text"
        label="PLG_TINY_FIELD_PROHIBITED_LABEL"
        description="PLG_TINY_FIELD_PROHIBITED_DESC"
        showon="use_config_textfilters:0"
        default="script,applet,iframe"
        class="input-xxlarge"
    />

    <field
        name="valid_elements"
        type="text"
        label="PLG_TINY_FIELD_VALIDELEMENTS_LABEL"
        description="PLG_TINY_FIELD_VALIDELEMENTS_DESC"
        showon="use_config_textfilters:0"
        class="input-xxlarge"
    />

    <field
        name="extended_elements"
        type="text"
        label="PLG_TINY_FIELD_ELEMENTS_LABEL"
        description="PLG_TINY_FIELD_ELEMENTS_DESC"
        showon="use_config_textfilters:0"
        class="input-xxlarge"
    />

    <!-- Extra plugins -->
    <field
        name="resizing"
        type="radio"
        label="PLG_TINY_FIELD_RESIZING_LABEL"
        description="PLG_TINY_FIELD_RESIZING_DESC"
        class="btn-group btn-group-yesno"
        default="1"
        >
        <option value="1">JON</option>
        <option value="0">JOFF</option>
    </field>

    <field
        name="resize_horizontal"
        type="radio"
        label="PLG_TINY_FIELD_RESIZE_HORIZONTAL_LABEL"
        description="PLG_TINY_FIELD_RESIZE_HORIZONTAL_DESC"
        class="btn-group btn-group-yesno"
        default="1"
        showon="resizing:1"
        >
        <option value="1">JON</option>
        <option value="0">JOFF</option>
    </field>

    <field
        name="element_path"
        type="radio"
        label="PLG_TINY_FIELD_PATH_LABEL"
        description="PLG_TINY_FIELD_PATH_DESC"
        class="btn-group btn-group-yesno"
        default="0"
        >
        <option value="1">JON</option>
        <option value="0">JOFF</option>
    </field>

    <field
        name="wordcount"
        type="radio"
        label="PLG_TINY_FIELD_WORDCOUNT_LABEL"
        description="PLG_TINY_FIELD_WORDCOUNT_DESC"
        class="btn-group btn-group-yesno"
        default="1"
        >
        <option value="1">JON</option>
        <option value="0">JOFF</option>
    </field>

    <field
        name="image_advtab"
        type="radio"
        label="PLG_TINY_FIELD_ADVIMAGE_LABEL"
        description="PLG_TINY_FIELD_ADVIMAGE_DESC"
        class="btn-group btn-group-yesno"
        default="1"
        >
        <option value="1">JON</option>
        <option value="0">JOFF</option>
    </field>

    <field
        name="advlist"
        type="radio"
        label="PLG_TINY_FIELD_ADVLIST_LABEL"
        description="PLG_TINY_FIELD_ADVLIST_DESC"
        class="btn-group btn-group-yesno"
        default="1"
        >
        <option value="1">JON</option>
        <option value="0">JOFF</option>
    </field>

    <field
        name="contextmenu"
        type="radio"
        label="PLG_TINY_FIELD_CONTEXTMENU_LABEL"
        description="PLG_TINY_FIELD_CONTEXTMENU_DESC"
        class="btn-group btn-group-yesno"
        default="1"
        >
        <option value="1">JON</option>
        <option value="0">JOFF</option>
    </field>

    <field
        name="custom_plugin"
        type="text"
        label="PLG_TINY_FIELD_CUSTOMPLUGIN_LABEL"
        description="PLG_TINY_FIELD_CUSTOMPLUGIN_DESC"
        class="input-xxlarge"
    />

    <field
        name="custom_button"
        type="text"
        label="PLG_TINY_FIELD_CUSTOMBUTTON_LABEL"
        description="PLG_TINY_FIELD_CUSTOMBUTTON_DESC"
        class="input-xxlarge"
    />
</form>                                                                                               <?php
/**
 * @package     Joomla.Plugin
 * @subpackage  Editors.none
 *
 * @copyright   (C) 2006 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/**
 * Plain Textarea Editor Plugin
 *
 * @since  1.5
 */
class PlgEditorNone extends JPlugin
{
	/**
	 * Method to handle the onInitEditor event.
	 *  - Initialises the Editor
	 *
	 * @return  void
	 *
	 * @since 1.5
	 */
	public function onInit()
	{
		JHtml::_('script', 'editors/none/none.min.js', array('version' => 'auto', 'relative' => true));
	}

	/**
	 * Copy editor content to form field.
	 *
	 * Not applicable in this editor.
	 *
	 * @param   string  $editor  the editor id
	 *
	 * @return  void
	 *
	 * @deprecated 4.0 Use directly the returned code
	 */
	public function onSave($editor)
	{
	}

	/**
	 * Get the editor content.
	 *
	 * @param   string  $id  The id of the editor field.
	 *
	 * @return  string
	 *
	 * @deprecated 4.0 Use directly the returned code
	 */
	public function onGetContent($id)
	{
		return 'Joomla.editors.instances[' . json_encode($id) . '].getValue();';
	}

	/**
	 * Set the editor content.
	 *
	 * @param   string  $id    The id of the editor field.
	 * @param   string  $html  The content to set.
	 *
	 * @return  string
	 *
	 * @deprecated 4.0 Use directly the returned code
	 */
	public function onSetContent($id, $html)
	{
		return 'Joomla.editors.instances[' . json_encode($id) . '].setValue(' . json_encode($html) . ');';
	}

	/**
	 * Inserts html code into the editor
	 *
	 * @param   string  $id  The id of the editor field
	 *
	 * @return  void
	 *
	 * @deprecated 4.0
	 */
	public function onGetInsertMethod($id)
	{
	}

	/**
	 * Display the editor area.
	 *
	 * @param   string   $name     The control name.
	 * @param   string   $content  The contents of the text area.
	 * @param   string   $width    The width of the text area (px or %).
	 * @param   string   $height   The height of the text area (px or %).
	 * @param   integer  $col      The number of columns for the textarea.
	 * @param   integer  $row      The number of rows for the textarea.
	 * @param   boolean  $buttons  True and the editor buttons will be displayed.
	 * @param   string   $id       An optional ID for the textarea (note: since 1.6). If not supplied the name is used.
	 * @param   string   $asset    The object asset
	 * @param   object   $author   The author.
	 * @param   array    $params   Associative array of editor parameters.
	 *
	 * @return  string
	 */
	public function onDisplay($name, $content, $width, $height, $col, $row, $buttons = true,
		$id = null, $asset = null, $author = null, $params = array())
	{
		if (empty($id))
		{
			$id = $name;
		}

		// Only add "px" to width and height if they are not given as a percentage
		if (is_numeric($width))
		{
			$width .= 'px';
		}

		if (is_numeric($height))
		{
			$height .= 'px';
		}

		$readonly = !empty($params['readonly']) ? ' readonly disabled' : '';

		$editor = '<div class="js-editor-none">'
			. '<textarea name="' . $name . '" id="' . $id . '" cols="' . $col . '" rows="' . $row
			. '" style="width: ' . $width . '; height: ' . $height . ';"' . $readonly . '>' . $content . '</textarea>'
			. $this->_displayButtons($id, $buttons, $asset, $author)
			. '</div>';

		return $editor;
	}

	/**
	 * Displays the editor buttons.
	 *
	 * @param   string  $name     The control name.
	 * @param   mixed   $buttons  [array with button objects | boolean true to display buttons]
	 * @param   string  $asset    The object asset
	 * @param   object  $author   The author.
	 *
	 * @return  void|string HTML
	 */
	public function _displayButtons($name, $buttons, $asset, $author)
	{
		if (is_array($buttons) || (is_bool($buttons) && $buttons))
		{
			$buttons = $this->_subject->getButtons($name, $buttons, $asset, $author);

			return JLayoutHelper::render('joomla.editors.buttons', $buttons);
		}
	}
}
