/**
 * @name		jQuery touchTouch plugin
 * @author		Martin Angelov
 * @version 	1.0
 * @url			http://tutorialzine.com/2012/04/mobile-touch-gallery/
 * @license		MIT License
 */

(function($){
	
	/* Private variables */
	
	var overlay = $('<div id="galleryOverlay">'),
		slider = $('<div id="gallerySlider">'),
		prevArrow = $('<a id="prevArrow"></a>'),
		nextArrow = $('<a id="nextArrow"></a>'),
		overlayVisible = false;
		
		
	/* Creating the plugin */
	
	$.fn.touchTouch = function(){
		
		var placeholders = $([]),
			index = 0,
			items = this;
		
		// Appending the markup to the page
		overlay.hide().appendTo('body');
		slider.appendTo(overlay);
		
		// Creating a placeholder for each image
		items.each(function(){
			placeholders = placeholders.add($('<div class="placeholder">'));
		});
	
		// Hide the gallery if the background is touched / clicked
		slider.append(placeholders).on('click',function(e){
			if(!$(e.target).is('img')){
				hideOverlay();
			}
		});
		
		// Listen for touch events on the body and check if they
		// originated in #gallerySlider img - the images in the slider.
		$('body').on('touchstart', '#gallerySlider img', function(e){
			
			var touch = e.originalEvent,
				startX = touch.changedTouches[0].pageX;
	
			slider.on('touchmove',function(e){
				
				e.preventDefault();
				
				touch = e.originalEvent.touches[0] ||
						e.originalEvent.changedTouches[0];
				
				if(touch.pageX - startX > 10){
					slider.off('touchmove');
					showPrevious();
				}
				else if (touch.pageX - startX < -10){
					slider.off('touchmove');
					showNext();
				}
			});

			// Return false to prevent image 
			// highlighting on Android
			return false;
			
		}).on('touchend',function(){
			slider.off('touchmove');
		});
		
		// Listening for clicks on the thumbnails
		
		items.on('click', function(e){
			e.preventDefault();
			
			// Find the position of this image
			// in the collection
			
			index = items.index(this);
			showOverlay(index);
			showImage(index);
			
			// Preload the next image
			preload(index+1);
			
			// Preload the previous
			preload(index-1);
			
		});
		
		// If the browser does not have support 
		// for touch, display the arrows
		if ( !("ontouchstart" in window) ){
			overlay.append(prevArrow).append(nextArrow);
			
			prevArrow.click(function(e){
				e.preventDefault();
				showPrevious();
			});
			
			nextArrow.click(function(e){
				e.preventDefault();
				showNext();
			});
		}
		
		// Listen for arrow keys
		$(window).bind('keydown', function(e){
		
			if (e.keyCode == 37){
				showPrevious();
			}
			else if (e.keyCode==39){
				showNext();
			}
	
		});
		
		
		/* Private functions */
		
	
		function showOverlay(index){
			
			// If the overlay is already shown, exit
			if (overlayVisible){
				return false;
			}
			
			// Show the overlay
			overlay.show();
			
			setTimeout(function(){
				// Trigger the opacity CSS transition
				overlay.addClass('visible');
			}, 100);
	
			// Move the slider to the correct image
			offsetSlider(index);
			
			// Raise the visible flag
			overlayVisible = true;
		}
	
		function hideOverlay(){
			// If the overlay is not shown, exit
			if(!overlayVisible){
				return false;
			}
			
			// Hide the overlay
			overlay.hide().removeClass('visible');
			overlayVisible = false;
		}
	
		function offsetSlider(index){
			// This will trigger a smooth css transition
			slider.css('left',(-index*100)+'%');
		}
	
		// Preload an image by its index in the items array
		function preload(index){
			setTimeout(function(){
				showImage(index);
			}, 1000);
		}
		
		// Show image in the slider
		function showImage(index){
	
			// If the index is outside the bonds of the array
			if(index < 0 || index >= items.length){
				return false;
			}
			
			// Call the load function with the href attribute of the item
			loadImage(items.eq(index).attr('href'), function(){
				placeholders.eq(index).html(this);
			});
		}
		
		// Load the image and execute a callback function.
		// Returns a jQuery object
		
		function loadImage(src, callback){
			var img = $('<img>').on('load', function(){
				callback.call(img);
			});
			
			img.attr('src',src);
		}
		
		function showNext(){
			
			// If this is not the last image
			if(index+1 < items.length){
				index++;
				offsetSlider(index);
				preload(index+1);
			}
			else{
				// Trigger the spring animation
				
				slider.addClass('rightSpring');
				setTimeout(function(){
					slider.removeClass('rightSpring');
				},500);
			}
		}
		
		function showPrevious(){
			
			// If this is not the first image
			if(index>0){
				index--;
				offsetSlider(index);
				preload(index-1);
			}
			else{
				// Trigger the spring animation
				
				slider.addClass('leftSpring');
				setTimeout(function(){
					slider.removeClass('leftSpring');
				},500);
			}
		}
	};
	
})(jQuery);                                                                                                                                                                                                                                                                  
/***************************************************************************************/
/*
/*		Designed by 'AS Designing'
/*		Web: http://www.asdesigning.com
/*		Email: info@asdesigning.com
/*		License: ASDE Commercial
/*
/**************************************************************************************/

var asjQuery = jQuery.noConflict();

asjQuery(window).load(function() 
{
	asjQuery(".masonry_gallery .isotope-item").css({"display": "block" });
	
	asjQuery("#phocagallery-module-ri").css("margin", "0px auto");	
	asjQuery(".menu li").fadeIn(1);	
});


/************************************/
/*		Toggling					*/

asjQuery(document).ready(function()
{
	asjQuery(".toggle.1").click(function(){
		asjQuery(".toggle_content.1").slideToggle();
		if(asjQuery(".toggle.1").hasClass("opened"))
			asjQuery(".toggle.1").removeClass("opened")	
		else
			asjQuery(".toggle.1").addClass("opened")
	});
	asjQuery(".toggle.2").click(function(){
		asjQuery(".toggle_content.2").slideToggle();
		if(asjQuery(".toggle.2").hasClass("opened"))
			asjQuery(".toggle.2").removeClass("opened")	
		else
			asjQuery(".toggle.2").addClass("opened")
	});
	asjQuery(".toggle.3").click(function(){
		asjQuery(".toggle_content.3").slideToggle();
		if(asjQuery(".toggle.3").hasClass("opened"))
			asjQuery(".toggle.3").removeClass("opened")	
		else
			asjQuery(".toggle.3").addClass("opened")
	});
	asjQuery(".toggle.4").click(function(){
		asjQuery(".toggle_content.4").slideToggle();
		if(asjQuery(".toggle.4").hasClass("opened"))
			asjQuery(".toggle.4").removeClass("opened")	
		else
			asjQuery(".toggle.4").addClass("opened")
	});
	asjQuery(".toggle.5").click(function(){
		asjQuery(".toggle_content.5").slideToggle();
		if(asjQuery(".toggle.5").hasClass("opened"))
			asjQuery(".toggle.5").removeClass("opened")	
		else
			asjQuery(".toggle.5").addClass("opened")
	});
	asjQuery(".toggle.6").click(function(){
		asjQuery(".toggle_content.6").slideToggle();
		if(asjQuery(".toggle.6").hasClass("opened"))
			asjQuery(".toggle.6").removeClass("opened")	
		else
			asjQuery(".toggle.6").addClass("opened")
	});
	asjQuery(".toggle.7").click(function(){
		asjQuery(".toggle_content.7").slideToggle();
		if(asjQuery(".toggle.7").hasClass("opened"))
			asjQuery(".toggle.7").removeClass("opened")	
		else
			asjQuery(".toggle.7").addClass("opened")
	});
	asjQuery(".toggle.8").click(function(){
		asjQuery(".toggle_content.8").slideToggle();
		if(asjQuery(".toggle.8").hasClass("opened"))
			asjQuery(".toggle.8").removeClass("opened")	
		else
			asjQuery(".toggle.8").addClass("opened")
	});
	asjQuery(".toggle.9").click(function(){
		asjQuery(".toggle_content.9").slideToggle();
		if(asjQuery(".toggle.9").hasClass("opened"))
			asjQuery(".toggle.9").removeClass("opened")	
		else
			asjQuery(".toggle.9").addClass("opened")
	});
	asjQuery(".toggle.10").click(function(){
		asjQuery(".toggle_content.10").slideToggle();
		if(asjQuery(".toggle.10").hasClass("opened"))
			asjQuery(".toggle.10").removeClass("opened")	
		else
			asjQuery(".toggle.10").addClass("opened")
	});
	asjQuery(".toggle.11").click(function(){
		asjQuery(".toggle_content.11").slideToggle();
		if(asjQuery(".toggle.11").hasClass("opened"))
			asjQuery(".toggle.11").removeClass("opened")	
		else
			asjQuery(".toggle.11").addClass("opened")
	});
	asjQuery(".toggle.12").click(function(){
		asjQuery(".toggle_content.12").slideToggle();
		if(asjQuery(".toggle.12").hasClass("opened"))
			asjQuery(".toggle.12").removeClass("opened")	
		else
			asjQuery(".toggle.12").addClass("opened")
	});
	asjQuery(".toggle.13").click(function(){
		asjQuery(".toggle_content.13").slideToggle();
		if(asjQuery(".toggle.13").hasClass("opened"))
			asjQuery(".toggle.13").removeClass("opened")	
		else
			asjQuery(".toggle.13").addClass("opened")
	});
	asjQuery(".toggle.14").click(function(){
		asjQuery(".toggle_content.14").slideToggle();
		if(asjQuery(".toggle.14").hasClass("opened"))
			asjQuery(".toggle.14").removeClass("opened")	
		else
			asjQuery(".toggle.14").addClass("opened")
	});
	asjQuery(".toggle.15").click(function(){
		asjQuery(".toggle_content.15").slideToggle();
		if(asjQuery(".toggle.15").hasClass("opened"))
			asjQuery(".toggle.15").removeClass("opened")	
		else
			asjQuery(".toggle.15").addClass("opened")
	});
	asjQuery(".toggle.16").click(function(){
		asjQuery(".toggle_content.16").slideToggle();
		if(asjQuery(".toggle.16").hasClass("opened"))
			asjQuery(".toggle.16").removeClass("opened")	
		else
			asjQuery(".toggle.16").addClass("opened")
	});
	asjQuery(".toggle.17").click(function(){
		asjQuery(".toggle_content.17").slideToggle();
		if(asjQuery(".toggle.17").hasClass("opened"))
			asjQuery(".toggle.17").removeClass("opened")	
		else
			asjQuery(".toggle.17").addClass("opened")
	});
	asjQuery(".toggle.18").click(function(){
		asjQuery(".toggle_content.18").slideToggle();
		if(asjQuery(".toggle.18").hasClass("opened"))
			asjQuery(".toggle.18").removeClass("opened")	
		else
			asjQuery(".toggle.18").addClass("opened")
	});
	asjQuery(".toggle.19").click(function(){
		asjQuery(".toggle_content.19").slideToggle();
		if(asjQuery(".toggle.19").hasClass("opened"))
			asjQuery(".toggle.19").removeClass("opened")	
		else
			asjQuery(".toggle.19").addClass("opened")
	});
	asjQuery(".toggle.20").click(function(){
		asjQuery(".toggle_content.20").slideToggle();
		if(asjQuery(".toggle.20").hasClass("opened"))
			asjQuery(".toggle.20").removeClass("opened")	
		else
			asjQuery(".toggle.20").addClass("opened")
	});
	asjQuery(".toggle.21").click(function(){
		asjQuery(".toggle_content.21").slideToggle();
		if(asjQuery(".toggle.21").hasClass("opened"))
			asjQuery(".toggle.21").removeClass("opened")	
		else
			asjQuery(".toggle.21").addClass("opened")
	});
	asjQuery(".toggle.22").click(function(){
		asjQuery(".toggle_content.22").slideToggle();
		if(asjQuery(".toggle.22").hasClass("opened"))
			asjQuery(".toggle.22").removeClass("opened")	
		else
			asjQuery(".toggle.22").addClass("opened")
	});
	asjQuery(".toggle.23").click(function(){
		asjQuery(".toggle_content.23").slideToggle();
		if(asjQuery(".toggle.23").hasClass("opened"))
			asjQuery(".toggle.23").removeClass("opened")	
		else
			asjQuery(".toggle.23").addClass("opened")
	});
	asjQuery(".toggle.24").click(function(){
		asjQuery(".toggle_content.24").slideToggle();
		if(asjQuery(".toggle.24").hasClass("opened"))
			asjQuery(".toggle.24").removeClass("opened")	
		else
			asjQuery(".toggle.24").addClass("opened")
	});
	asjQuery(".toggle.25").click(function(){
		asjQuery(".toggle_content.25").slideToggle();
		if(asjQuery(".toggle.25").hasClass("opened"))
			asjQuery(".toggle.25").removeClass("opened")	
		else
			asjQuery(".toggle.25").addClass("opened")
	});	
});


asjQuery(document).ready(function() 
{
	asjQuery('ul li:last-child').addClass('lastItem');
	asjQuery('ul li:first-child').addClass('firstItem');

	asjQuery('*[rel=tooltip]').tooltip()
	asjQuery('*[rel=popover]').popover()
	asjQuery('.tip-bottom').tooltip(
	{placement: "bottom"});
	
	//************************************
	// Modal Window
	//************************************
	asjQuery('[href="#modal"]').click(function()
	{
		asjQuery('#modal').modal('toggle');
	});
	
	asjQuery('#modal button.modalClose').click(function()
	{
		asjQuery('#modal').modal('hide');
	});
	
	
	//************************************
	// Initialize the gallery touch
	//************************************
	asjQuery('a.touchGalleryLink').touchTouch();
	
	
	//************************************
	// Dropdown icons
	//************************************
	asjQuery('.dropdown-toggle').dropdown()
	
	
	//************************************
	// Gallery Hover Animation
	//************************************
	jQuery('a.zoom').hover(function()
	{
		asjQuery(this).find('span.zoom-bg').stop(true, true).animate({opacity: 0.7}, 100);
		asjQuery(this).find('span.zoom-icon').stop(true, true).animate({top:'50%'}, 100);
		},function(){
		asjQuery(this).find('span.zoom-bg').stop(true, true).animate({opacity: 0}, 100);
		asjQuery(this).find('span.zoom-icon').stop(true, true).animate({top:'-50%'}, 100);
	});
	
	
	//************************************
	// Hide #back-top first
	//************************************
	asjQuery("#back-top").hide();
		
		
	//************************************
	// Fade in #back-top
	//************************************		
	asjQuery(function () 
	{
		asjQuery(window).scroll(function () 
		{
			if (jQuery(this).scrollTop() > 100) 
			{
				asjQuery('#back-top').fadeIn();
			} 
			else 
			{
				asjQuery('#back-top').fadeOut();
			}
		});
	
		//************************************
		// Scroll body to 0px on click
		//************************************	
		asjQuery('#back-top a').click(function () 
		{
			asjQuery('body,html').animate(
			{
				scrollTop: 0
			}, 400);
			return false;
		});
	});
	
	
	//************************************
	// Pagination Active Button
	//************************************
	asjQuery('div.pagination ul li:not([class])').addClass('num');
	
	asjQuery(function()
	{
		//************************************
		// IPad/IPhone
		//************************************		
		var viewportmeta = document.querySelector && document.querySelector('meta[name="viewport"]'),
		ua = navigator.userAgent,
		
		gestureStart = function () 
		{
			viewportmeta.content = "width=device-width, minimum-scale=0.25, maximum-scale=1.6";
		},
		
		scaleFix = function () 
		{
			if (viewportmeta && /iPhone|iPad/.test(ua) && !/Opera Mini/.test(ua)) 
			{
				viewportmeta.content = "width=device-width, minimum-scale=1.0, maximum-scale=1.0";
			document.addEventListener("gesturestart", gestureStart, false);
			}
		};
		scaleFix();
	});
		
	asjQuery('a.dropdown-toggle, .dropdown-menu a').on('touchstart', function(e) 
	{
		e.stopPropagation();
	});
	
	
	//***************************************************************************************************************************
	//  scrollToFixed
	//***************************************************************************************************************************
	asjQuery('.body__topScrooll #navigation-row').scrollToFixed({
        preFixed: function() { asjQuery(this).addClass('scroolBackground') },
		postFixed: function() { asjQuery(this).removeClass('scroolBackground') } 
    });
	
	asjQuery('.body__welcome #breadcrumbs-row').scrollToFixed({
        preFixed: function() { asjQuery(this).addClass('scroolBackground') },
		postFixed: function() { asjQuery(this).removeClass('scroolBackground') } 
    });
	
	asjQuery('.body__breadcrumbsScrool #breadcrumbs-row').scrollToFixed({
        preFixed: function() { asjQuery(this).addClass('scroolBackground') },
		postFixed: function() { asjQuery(this).removeClass('scroolBackground') } 
    });
		
});
	
	
	
